/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.businessservice.views;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.businessservices.BusinessServiceCheck;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BaseBusinessService;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.businessservice.dialogs.EditBusinessServiceCheckDlg;
import org.netxms.nxmc.modules.businessservice.views.helpers.BusinessServiceCheckFilter;
import org.netxms.nxmc.modules.businessservice.views.helpers.BusinessServiceCheckLabelProvider;
import org.netxms.nxmc.modules.businessservice.views.helpers.BusinessServiceComparator;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.RefreshTimer;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class BusinessServiceChecksView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(BusinessServiceChecksView.class);
    private static final String ID = "BusinessServiceChecks";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_OBJECT = 3;
    public static final int COLUMN_DCI = 4;
    public static final int COLUMN_STATUS = 5;
    public static final int COLUMN_FAIL_REASON = 6;
    public static final int COLUMN_ORIGIN = 7;
    private SessionListener sessionListener;
    private SortableTableViewer viewer;
    private BusinessServiceCheckLabelProvider labelProvider;
    private Action actionEdit;
    private Action actionCreate;
    private Action actionDelete;
    private Action actionShowObjectDetails;
    private Map<Long, BusinessServiceCheck> checks;
    private Map<Long, BusinessServiceCheck> updatedChecks = new HashMap();
    private Set<Long> deletedChecks = new HashSet();
    private RefreshTimer refreshTimer;

    public BusinessServiceChecksView() {
        super(i18n.tr("Checks"), ResourceManager.getImageDescriptor((String)"icons/object-views/service_check.gif"), ID, true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Description"), i18n.tr("Type"), i18n.tr("Object"), i18n.tr("DCI"), i18n.tr("Status"), i18n.tr("Reason"), i18n.tr("Origin")};
        int[] widths = new int[]{70, 200, 100, 200, 200, 70, 300, 300};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, -1);
        this.labelProvider = new BusinessServiceCheckLabelProvider();
        BusinessServiceCheckFilter filter = new BusinessServiceCheckFilter(this.labelProvider);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.setComparator((ViewerComparator)new BusinessServiceComparator(this.labelProvider));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (String)ID);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.refreshTimer = new RefreshTimer(300, this.viewer.getControl(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    public void refresh() {
        AbstractObject object = this.getObject();
        if (object == null) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowObjectDetails);
    }

    private void createActions() {
        this.actionCreate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowObjectDetails = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void deleteCheck() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Confirm Delete"), (String)i18n.tr("Do you really want to delete selected check?"))) {
            return;
        }
        BusinessServiceCheck[] checks = new BusinessServiceCheck[selection.size()];
        int i = 0;
        for (Object o : selection.toList()) {
            checks[i++] = (BusinessServiceCheck)o;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void editCheck() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        BusinessServiceCheck check = new BusinessServiceCheck((BusinessServiceCheck)selection.getFirstElement());
        EditBusinessServiceCheckDlg dlg = new EditBusinessServiceCheckDlg(this.getWindow().getShell(), check, false);
        if (dlg.open() == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void createCheck() {
        BusinessServiceCheck check = new BusinessServiceCheck();
        EditBusinessServiceCheckDlg dlg = new EditBusinessServiceCheckDlg(this.getWindow().getShell(), check, false);
        if (dlg.open() == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    protected void onObjectChange(AbstractObject object) {
        this.viewer.setInput((Object)new Object[0]);
        this.refresh();
    }

    public void updateDciLabels(Collection<BusinessServiceCheck> checks) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void syncMissingObjects(Collection<BusinessServiceCheck> checks) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof BaseBusinessService;
    }

    public int getPriority() {
        return 60;
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    private void showObjectDetails() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        BusinessServiceCheck check = new BusinessServiceCheck((BusinessServiceCheck)selection.getFirstElement());
        if (check.getObjectId() == 0L) {
            return;
        }
        AbstractObject object = this.session.findObjectById(check.getObjectId());
    }

    static /* synthetic */ NXCSession access$000(BusinessServiceChecksView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$100(BusinessServiceChecksView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$200(BusinessServiceChecksView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$300(BusinessServiceChecksView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$400(BusinessServiceChecksView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$500(BusinessServiceChecksView x0) {
        return x0.session;
    }
}

