/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfigFactory;
import org.netxms.nxmc.modules.dashboards.dialogs.ImportDashboardDialog;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.DciIdMatchingData;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.ObjectIdMatchingData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class DashboardImporter {
    private final I18n i18n = LocalizationHelper.getI18n(DashboardImporter.class);
    private View view;
    private long parentId;
    private String objectName;

    public DashboardImporter(View view, long parentId, String objectName) {
        this.view = view;
        this.parentId = parentId;
        this.objectName = objectName;
    }

    public void run() {
        ImportDashboardDialog dlg = new ImportDashboardDialog(this.view.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        NXCSession session = Registry.getSession();
        Display display = Display.getCurrent();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private boolean doIdMapping(Display display, NXCSession session, List<DashboardElement> dashboardElements, Element root) throws Exception {
        Map objects = this.readSourceObjects(root);
        Map dcis = this.readSourceDci(root);
        for (DciIdMatchingData d : dcis.values()) {
            if (d.srcNodeId == 0xFFFFFFFFL || objects.containsKey(d.srcNodeId)) continue;
            objects.put(d.srcNodeId, new ObjectIdMatchingData(d.srcNodeId, "", 2));
        }
        for (DciIdMatchingData d : objects.values()) {
            AbstractObject object;
            if (d.srcId < 10L || d.srcId == 0xFFFFFFFFL) {
                d.dstId = d.srcId;
                continue;
            }
            if (d.srcName.isEmpty() || (object = session.findObjectByName(d.srcName)) == null || !DashboardImporter.isCompatibleClasses((int)object.getObjectClass(), (int)d.objectClass)) continue;
            d.dstId = object.getObjectId();
            d.dstName = object.getObjectName();
        }
        block2: for (DciIdMatchingData d : dcis.values()) {
            DciValue[] dciValues;
            ObjectIdMatchingData od = (ObjectIdMatchingData)objects.get(d.srcNodeId);
            od.dcis.add(d);
            if (od.dstId == 0L) continue;
            d.dstNodeId = od.dstId;
            for (DciValue v : dciValues = session.getLastValues(d.dstNodeId)) {
                if (!v.getDescription().equalsIgnoreCase(d.srcName)) continue;
                d.dstDciId = v.getId();
                d.dstName = v.getDescription();
                continue block2;
            }
        }
        boolean[] success = new boolean[1];
        display.syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        if (success[0]) {
            for (DashboardElement e : dashboardElements) {
                this.updateDashboardElement(e, objects, dcis);
            }
            return true;
        }
        return false;
    }

    public static boolean isCompatibleClasses(int c1, int c2) {
        return c1 == c2 || c1 == 2 && c2 == 14 || c1 == 14 && c2 == 2;
    }

    private void updateDashboardElement(DashboardElement e, Map<Long, ObjectIdMatchingData> objects, Map<Long, DciIdMatchingData> dcis) throws Exception {
        DashboardElementConfig config = DashboardElementConfigFactory.create((DashboardElement)e);
        if (config == null) {
            return;
        }
        config.remapObjects(objects);
        config.remapDataCollectionItems(dcis);
        e.setData(config.createXml());
    }

    private Map<Long, ObjectIdMatchingData> readSourceObjects(Element root) {
        HashMap<Long, ObjectIdMatchingData> objects = new HashMap<Long, ObjectIdMatchingData>();
        NodeList objectsRoot = root.getElementsByTagName("objectMap");
        for (int i = 0; i < objectsRoot.getLength(); ++i) {
            if (objectsRoot.item(i).getNodeType() != 1) continue;
            NodeList elements = ((Element)objectsRoot.item(i)).getElementsByTagName("object");
            for (int j = 0; j < elements.getLength(); ++j) {
                Element e = (Element)elements.item(j);
                long id = DashboardImporter.getAttributeAsLong((Element)e, (String)"id", (long)0L);
                objects.put(id, new ObjectIdMatchingData(id, e.getTextContent(), (int)DashboardImporter.getAttributeAsLong((Element)e, (String)"class", (long)0L)));
            }
        }
        return objects;
    }

    private Map<Long, DciIdMatchingData> readSourceDci(Element root) {
        HashMap<Long, DciIdMatchingData> dcis = new HashMap<Long, DciIdMatchingData>();
        NodeList objectsRoot = root.getElementsByTagName("dciMap");
        for (int i = 0; i < objectsRoot.getLength(); ++i) {
            if (objectsRoot.item(i).getNodeType() != 1) continue;
            NodeList elements = ((Element)objectsRoot.item(i)).getElementsByTagName("dci");
            for (int j = 0; j < elements.getLength(); ++j) {
                Element e = (Element)elements.item(j);
                long id = DashboardImporter.getAttributeAsLong((Element)e, (String)"id", (long)0L);
                dcis.put(id, new DciIdMatchingData(DashboardImporter.getAttributeAsLong((Element)e, (String)"node", (long)0L), id, e.getTextContent()));
            }
        }
        return dcis;
    }

    private static int getNodeValueAsInt(Element parent, String tag, int defaultValue) {
        NodeList l = parent.getElementsByTagName(tag);
        if (l.getLength() == 0 || l.item(0).getNodeType() != 1) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(((Element)l.item(0)).getTextContent());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static long getAttributeAsLong(Element element, String attribute, long defaultValue) {
        try {
            return Long.parseLong(element.getAttribute(attribute));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static String getNodeValueAsXml(Element parent, String tag) throws TransformerFactoryConfigurationError, TransformerException {
        NodeList l = parent.getElementsByTagName(tag);
        if (l.getLength() == 0 || l.item(0).getNodeType() != 1) {
            return "<" + tag + "></" + tag + ">";
        }
        return DashboardImporter.nodeToString((Node)l.item(0));
    }

    private static String nodeToString(Node node) throws TransformerFactoryConfigurationError, TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }
}

