/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import java.util.Map;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusIndicatorConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.StatusIndicatorElement;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class StatusIndicatorElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(StatusIndicatorElement.class);
    private final I18n i18n = LocalizationHelper.getI18n(StatusIndicatorElement.class);
    private NXCSession session = Registry.getSession();
    private StatusIndicatorConfig config;
    private ViewRefreshController refreshController;
    private boolean requireScriptRun = false;
    private boolean requireDataCollection = false;
    private StatusIndicatorElementWidget[] elementWidgets;
    private static final int ELEMENT_HEIGHT = 36;

    protected StatusIndicatorElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = StatusIndicatorConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            logger.debug("Original XML:\n" + element.getData());
            this.config = new StatusIndicatorConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 16;
        layout.marginWidth = 16;
        layout.verticalSpacing = 16;
        layout.horizontalSpacing = 16;
        layout.numColumns = this.config.getNumColumns();
        layout.makeColumnsEqualWidth = true;
        this.getContentArea().setLayout((Layout)layout);
        this.elementWidgets = new StatusIndicatorElementWidget[this.config.getElements().length];
        for (int i = 0; i < this.elementWidgets.length; ++i) {
            StatusIndicatorConfig.StatusIndicatorElementConfig e = this.config.getElements()[i];
            if (e.getType() == 3) {
                this.requireScriptRun = true;
            } else if (e.getType() == 1 || e.getType() == 2) {
                this.requireDataCollection = true;
            }
            this.elementWidgets[i] = new StatusIndicatorElementWidget(this, this.getContentArea(), e);
            this.elementWidgets[i].setLayoutData((Object)new GridData(4, 4, true, false));
        }
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
        this.startRefreshTimer();
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void refreshData() {
        if (this.requireDataCollection || this.requireScriptRun) {
            3 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        } else {
            this.updateElements(null, null);
        }
    }

    private void updateElements(Map<String, String> scriptData, DciValue[] dciValues) {
        block7: for (StatusIndicatorElementWidget w : this.elementWidgets) {
            StatusIndicatorConfig.StatusIndicatorElementConfig e = w.getElementConfig();
            switch (e.getType()) {
                case 0: {
                    AbstractObject object = this.session.findObjectById(this.getEffectiveObjectId(e.getObjectId()));
                    w.setStatus(object != null ? object.getStatus() : ObjectStatus.UNKNOWN);
                    continue block7;
                }
                case 3: {
                    String value = scriptData.get(e.getTag());
                    if (value != null) {
                        try {
                            w.setStatus(ObjectStatus.getByValue((int)Integer.parseInt(value)));
                        }
                        catch (NumberFormatException ex) {
                            w.setStatus(ObjectStatus.UNKNOWN);
                        }
                        continue block7;
                    }
                    w.setStatus(ObjectStatus.UNKNOWN);
                    continue block7;
                }
                case 1: 
                case 2: {
                    boolean found = false;
                    if (dciValues != null) {
                        for (DciValue v : dciValues) {
                            if (v.getId() != e.getDciId()) continue;
                            Threshold t = v.getActiveThreshold();
                            w.setStatus(t != null ? ObjectStatus.getByValue((int)t.getCurrentSeverity().getValue()) : ObjectStatus.NORMAL);
                            found = true;
                            break;
                        }
                    }
                    if (found) continue block7;
                    w.setStatus(ObjectStatus.UNKNOWN);
                }
            }
        }
    }

    protected void startRefreshTimer() {
        this.refreshController = new ViewRefreshController((View)this.view, 15, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshData();
    }
}

