/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.imagelibrary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.LibraryImage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.imagelibrary.ImageUpdateListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ImageProvider {
    private static final Logger logger = LoggerFactory.getLogger(ImageProvider.class);
    private static ImageProvider instance = null;
    private static final Map<UUID, Image> cache = Collections.synchronizedMap(new HashMap());
    private static final Map<UUID, LibraryImage> libraryIndex = Collections.synchronizedMap(new HashMap());
    private final I18n i18n = LocalizationHelper.getI18n(ImageProvider.class);
    private final Image missingImage;
    private final Set<ImageUpdateListener> updateListeners;
    private NXCSession session;
    private Display display;

    public static void createInstance(Display display, NXCSession session) {
        if (instance == null) {
            instance = new ImageProvider(display, session);
        }
    }

    public static ImageProvider getInstance() {
        return instance;
    }

    private ImageProvider(Display display, NXCSession session) {
        this.display = display;
        this.session = session;
        this.missingImage = ResourceManager.getImage((String)"icons/missing.png");
        this.updateListeners = new HashSet();
    }

    public void addUpdateListener(ImageUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(ImageUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    public void syncMetaData() throws NXCException, IOException {
        List imageLibrary = this.session.getImageLibrary();
        libraryIndex.clear();
        this.clearCache();
        for (LibraryImage libraryImage : imageLibrary) {
            libraryIndex.put(libraryImage.getGuid(), libraryImage);
        }
    }

    private void clearCache() {
        for (Image image : cache.values()) {
            if (image == this.missingImage) continue;
            image.dispose();
        }
        cache.clear();
    }

    public Image getImage(UUID guid) {
        Image image;
        if (guid == null) {
            return this.missingImage;
        }
        if (cache.containsKey(guid)) {
            image = (Image)cache.get(guid);
        } else {
            image = this.missingImage;
            cache.put(guid, image);
            if (libraryIndex.containsKey(guid)) {
                new /* Unavailable Anonymous Inner Class!! */.start();
            }
        }
        return image;
    }

    private void loadImageFromServer(UUID guid) {
        try {
            LibraryImage libraryImage = this.session.getImage(guid);
            ByteArrayInputStream stream = new ByteArrayInputStream(libraryImage.getBinaryData());
            try {
                cache.put(guid, new Image((Device)this.display, (InputStream)stream));
                this.notifySubscribers(guid);
            }
            catch (SWTException e) {
                logger.error("Cannot decode image", (Throwable)e);
                cache.put(guid, this.missingImage);
            }
        }
        catch (Exception e) {
            logger.error("Cannot retrive image from server", (Throwable)e);
        }
    }

    private void notifySubscribers(UUID guid) {
        for (ImageUpdateListener listener : this.updateListeners) {
            listener.imageUpdated(guid);
        }
    }

    public LibraryImage getLibraryImageObject(UUID guid) {
        return (LibraryImage)libraryIndex.get(guid);
    }

    public List<LibraryImage> getImageLibrary() {
        return new ArrayList<LibraryImage>(libraryIndex.values());
    }

    public void updateImage(UUID guid) {
        Image image = (Image)cache.remove(guid);
        if (image != null && image != this.missingImage) {
            image.dispose();
        }
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    public void deleteImage(UUID guid) {
        Image image = (Image)cache.remove(guid);
        if (image != null && image != this.missingImage) {
            image.dispose();
        }
        libraryIndex.remove(guid);
        this.notifySubscribers(guid);
    }
}

