/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.base.propertypages.PropertyDialog;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.imagelibrary.ImageUpdateListener;
import org.netxms.nxmc.modules.imagelibrary.dialogs.ImageSelectionDialog;
import org.netxms.nxmc.modules.networkmaps.algorithms.ManualLayout;
import org.netxms.nxmc.modules.networkmaps.dialogs.EditGroupBoxDialog;
import org.netxms.nxmc.modules.networkmaps.propertypages.DCIContainerDataSources;
import org.netxms.nxmc.modules.networkmaps.propertypages.DCIContainerGeneral;
import org.netxms.nxmc.modules.networkmaps.propertypages.DCIImageGeneral;
import org.netxms.nxmc.modules.networkmaps.propertypages.DCIImageRules;
import org.netxms.nxmc.modules.networkmaps.propertypages.LinkDataSources;
import org.netxms.nxmc.modules.networkmaps.propertypages.LinkGeneral;
import org.netxms.nxmc.modules.networkmaps.propertypages.TextBoxGeneral;
import org.netxms.nxmc.modules.networkmaps.views.AbstractNetworkMapView;
import org.netxms.nxmc.modules.networkmaps.views.PredefinedMapView;
import org.netxms.nxmc.modules.networkmaps.views.helpers.LinkEditor;
import org.netxms.nxmc.modules.objects.ObjectPropertiesManager;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class PredefinedMapView
extends AbstractNetworkMapView
implements ImageUpdateListener {
    private static final I18n i18n = LocalizationHelper.getI18n(PredefinedMapView.class);
    private Action actionAddObject;
    private Action actionAddDCIContainer;
    private Action actionLinkObjects;
    private Action actionAddGroupBox;
    private Action actionAddImage;
    private Action actionRemove;
    private Action actionDCIContainerProperties;
    private Action actionDCIImageProperties;
    private Action actionMapProperties;
    private Action actionLinkProperties;
    private Action actionAddDCIImage;
    private Action actionAddTextBox;
    private Action actionTextBoxProperties;
    private Action actionGroupBoxProperties;
    private Action actionImageProperties;
    private Color defaultLinkColor = null;
    private boolean disableGeolocationBackground = false;
    private boolean readOnly = true;
    private Map<Long, Boolean> readOnlyFlagsCache = new HashMap();

    public PredefinedMapView() {
        super(i18n.tr("Map"), ResourceManager.getImageDescriptor((String)"icons/object-views/netmap.png"), "PredefinedMap");
    }

    protected PredefinedMapView(String subId) {
        super(i18n.tr("Map"), ResourceManager.getImageDescriptor((String)"icons/object-views/netmap.png"), "PredefinedMap@" + subId);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof NetworkMap;
    }

    public int getPriority() {
        return 15;
    }

    protected void onObjectChange(AbstractObject object) {
        Boolean cachedFlag = (Boolean)this.readOnlyFlagsCache.get(object.getObjectId());
        if (cachedFlag != null) {
            this.readOnly = cachedFlag;
            this.reconfigureViewer();
            this.refresh();
        } else {
            this.readOnly = true;
            1 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
            this.syncObjects();
        }
    }

    private void reconfigureViewer() {
        this.allowManualLayout = !this.readOnly;
        this.viewer.setDraggingEnabled(!this.readOnly);
        NetworkMap mapObject = this.getMapObject();
        if (mapObject == null) {
            return;
        }
        if (mapObject.getLayout() == MapLayoutAlgorithm.MANUAL) {
            this.automaticLayoutEnabled = false;
            this.viewer.setLayoutAlgorithm((LayoutAlgorithm)new ManualLayout());
        } else {
            this.automaticLayoutEnabled = true;
            this.layoutAlgorithm = mapObject.getLayout();
            this.setLayoutAlgorithm(this.layoutAlgorithm, true);
        }
        for (int i = 0; i < this.actionSetAlgorithm.length; ++i) {
            this.actionSetAlgorithm[i].setEnabled(this.automaticLayoutEnabled);
        }
        this.actionSaveLayout.setEnabled(!this.automaticLayoutEnabled);
        this.actionEnableAutomaticLayout.setChecked(this.automaticLayoutEnabled);
        if (mapObject.getBackground() != null && mapObject.getBackground().compareTo(NXCommon.EMPTY_GUID) != 0) {
            if (mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
                if (!this.disableGeolocationBackground) {
                    this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(mapObject.getBackground()), mapObject.isCenterBackgroundImage());
                }
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(mapObject.getBackground()), mapObject.isCenterBackgroundImage());
            }
        } else {
            this.viewer.setBackgroundImage(null, false);
        }
        this.setConnectionRouter(mapObject.getDefaultLinkRouting(), false);
        this.viewer.setBackgroundColor(ColorConverter.rgbFromInt((int)mapObject.getBackgroundColor()));
        if (mapObject.getDefaultLinkColor() >= 0) {
            this.defaultLinkColor = new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)mapObject.getDefaultLinkColor()));
            this.labelProvider.setDefaultLinkColor(this.defaultLinkColor);
        }
        this.setObjectDisplayMode(mapObject.getObjectDisplayMode(), false);
        this.labelProvider.setShowStatusBackground(mapObject.isShowStatusBackground());
        this.labelProvider.setShowStatusFrame(mapObject.isShowStatusFrame());
        this.labelProvider.setShowStatusIcons(mapObject.isShowStatusIcon());
        this.labelProvider.setShowLinkDirection(mapObject.isShowLinkDirection());
        this.labelProvider.setTranslucentLabelBackground(mapObject.isTranslucentLabelBackground());
        this.actionShowStatusBackground.setChecked(this.labelProvider.isShowStatusBackground());
        this.actionShowStatusFrame.setChecked(this.labelProvider.isShowStatusFrame());
        this.actionShowStatusIcon.setChecked(this.labelProvider.isShowStatusIcons());
        this.actionShowLinkDirection.setChecked(this.labelProvider.isShowLinkDirection());
        this.actionTranslucentLabelBkgnd.setChecked(this.labelProvider.isTranslucentLabelBackground());
    }

    public void setupMapControl() {
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addDropSupport();
        ImageProvider.getInstance().addUpdateListener((ImageUpdateListener)this);
        this.reconfigureViewer();
    }

    private void addDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDropSupport(3, transfers, (DropTargetListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void buildMapPage() {
        NetworkMap mapObject = this.getMapObject();
        this.mapPage = mapObject != null ? mapObject.createMapPage() : new NetworkMapPage("EMPTY");
        this.addDciToRequestList();
    }

    private void syncObjects() {
        this.mapPage = this.getMapObject().createMapPage();
        List mapObjectIds = this.mapPage.getObjectIds();
        mapObjectIds.addAll(this.mapPage.getAllLinkStatusObjects());
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected void createActions() {
        super.createActions();
        this.actionAddObject = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M3+A", (IAction)this.actionAddObject);
        this.actionAddDCIContainer = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M3+C", (IAction)this.actionAddDCIContainer);
        this.actionAddDCIImage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddGroupBox = new /* Unavailable Anonymous Inner Class!! */;
        this.actionGroupBoxProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddImage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionImageProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLinkObjects = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+L", (IAction)this.actionLinkObjects);
        this.actionRemove = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+R", (IAction)this.actionRemove);
        this.actionDCIContainerProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDCIImageProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMapProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLinkProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddTextBox = new /* Unavailable Anonymous Inner Class!! */;
        this.actionTextBoxProperties = new /* Unavailable Anonymous Inner Class!! */;
    }

    private IMenuManager createDecorationAdditionSubmenu() {
        MenuManager menu = new MenuManager(i18n.tr("Add &decoration"));
        menu.add((IAction)this.actionAddGroupBox);
        menu.add((IAction)this.actionAddImage);
        menu.add((IAction)this.actionAddTextBox);
        return menu;
    }

    protected void fillMapContextMenu(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionAddObject);
            manager.add((IAction)this.actionAddDCIContainer);
            manager.add((IAction)this.actionAddDCIImage);
            manager.add((IContributionItem)this.createDecorationAdditionSubmenu());
            manager.add((IContributionItem)new Separator());
        }
        super.fillMapContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionMapProperties);
    }

    protected void fillObjectContextMenu(IMenuManager manager) {
        if (!this.readOnly) {
            int size = ((IStructuredSelection)this.viewer.getSelection()).size();
            if (size == 2) {
                manager.add((IAction)this.actionLinkObjects);
            }
            manager.add((IAction)this.actionRemove);
            manager.add((IContributionItem)new Separator());
        }
        super.fillObjectContextMenu(manager);
    }

    protected void fillLinkContextMenu(IMenuManager manager) {
        if (this.readOnly) {
            super.fillLinkContextMenu(manager);
            return;
        }
        int size = ((IStructuredSelection)this.viewer.getSelection()).size();
        manager.add((IAction)this.actionRemove);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionLockLink);
        manager.add((IContributionItem)new Separator());
        super.fillLinkContextMenu(manager);
        if (size == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionLinkProperties);
        }
    }

    protected void fillElementContextMenu(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionRemove);
            Object o = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            if (o instanceof NetworkMapDCIContainer) {
                manager.add((IAction)this.actionDCIContainerProperties);
            } else if (o instanceof NetworkMapDCIImage) {
                manager.add((IAction)this.actionDCIImageProperties);
            } else if (o instanceof NetworkMapTextBox) {
                manager.add((IAction)this.actionTextBoxProperties);
            } else if (o instanceof NetworkMapDecoration) {
                manager.add((IAction)(((NetworkMapDecoration)o).getDecorationType() == 1 ? this.actionImageProperties : this.actionGroupBoxProperties));
            }
            manager.add((IContributionItem)new Separator());
        }
        super.fillElementContextMenu(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionAddObject);
            manager.add((IAction)this.actionLinkObjects);
            manager.add((IContributionItem)this.createDecorationAdditionSubmenu());
            manager.add((IContributionItem)new Separator());
        }
        super.fillLocalMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionMapProperties);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionAddObject);
            manager.add((IAction)this.actionLinkObjects);
            manager.add((IContributionItem)new Separator());
        }
        super.fillLocalToolBar(manager);
    }

    protected void saveLayout() {
        this.saveMap();
    }

    private void addObjectToMap() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        this.addObjectsFromList(dlg.getSelectedObjects(), null);
    }

    private void addObjectsFromList(List<AbstractObject> list, Point location) {
        int added = 0;
        for (AbstractObject object : list) {
            if (this.mapPage.findObjectElement(object.getObjectId()) != null) continue;
            NetworkMapObject mapObject = new NetworkMapObject(this.mapPage.createElementId(), object.getObjectId());
            if (location != null) {
                mapObject.setLocation(location.x, location.y);
            } else {
                mapObject.setLocation(40, 40);
            }
            this.mapPage.addElement((NetworkMapElement)mapObject);
            ++added;
        }
        if (added > 0) {
            this.saveMap();
        }
    }

    private void removeSelectedElements() {
        Object[] objects;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Confirm Removal"), (String)(selection.size() == 1 ? i18n.tr("Are you sure to remove selected element from map?") : i18n.tr("Are you sure to remove selected elements from map?")))) {
            return;
        }
        for (Object element : objects = selection.toArray()) {
            if (element instanceof AbstractObject) {
                this.mapPage.removeObjectElement(((AbstractObject)element).getObjectId());
                continue;
            }
            if (element instanceof NetworkMapElement) {
                this.mapPage.removeElement(((NetworkMapElement)element).getId());
                continue;
            }
            if (!(element instanceof NetworkMapLink)) continue;
            this.mapPage.removeLink((NetworkMapLink)element);
        }
        this.saveMap();
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private void saveMap() {
        this.updateObjectPositions();
        NXCObjectModificationData md = new NXCObjectModificationData(this.getObjectId());
        md.setMapContent(this.mapPage.getElements(), this.mapPage.getLinks());
        md.setMapLayout(this.automaticLayoutEnabled ? this.layoutAlgorithm : MapLayoutAlgorithm.MANUAL);
        md.setConnectionRouting(this.routingAlgorithm);
        md.setMapObjectDisplayMode(this.labelProvider.getObjectFigureType());
        int flags = this.getMapObject().getFlags();
        flags = this.labelProvider.isShowStatusIcons() ? (flags |= 1) : (flags &= 0xFFFFFFFE);
        flags = this.labelProvider.isShowStatusFrame() ? (flags |= 2) : (flags &= 0xFFFFFFFD);
        flags = this.labelProvider.isShowStatusBackground() ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        flags = this.labelProvider.isShowLinkDirection() ? (flags |= 0x40) : (flags &= 0xFFFFFFBF);
        flags = this.labelProvider.isTranslucentLabelBackground() ? (flags |= 0x200) : (flags &= 0xFFFFFDFF);
        md.setObjectFlags(flags);
        new /* Unavailable Anonymous Inner Class!! */.start();
        this.addDciToRequestList();
    }

    private void showMapProperties() {
        this.updateObjectPositions();
        ObjectPropertiesManager.openObjectPropertiesDialog((AbstractObject)this.getMapObject(), (Shell)this.getWindow().getShell());
    }

    protected boolean isSelectableElement(Object element) {
        return element instanceof NetworkMapDecoration || element instanceof NetworkMapLink || element instanceof NetworkMapDCIContainer || element instanceof NetworkMapDCIImage || element instanceof NetworkMapTextBox;
    }

    public void imageUpdated(UUID guid) {
        this.getWindow().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void dispose() {
        ImageProvider.getInstance().removeUpdateListener((ImageUpdateListener)this);
        if (this.defaultLinkColor != null) {
            this.defaultLinkColor.dispose();
        }
        super.dispose();
    }

    protected void processObjectUpdateNotification(AbstractObject object) {
        super.processObjectUpdateNotification(object);
        if (object.getObjectId() != this.getMapObject().getObjectId()) {
            return;
        }
        NetworkMap mapObject = (NetworkMap)object;
        UUID oldBackground = mapObject.getBackground();
        if (!oldBackground.equals(mapObject.getBackground()) || mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
            if (mapObject.getBackground().equals(NXCommon.EMPTY_GUID)) {
                this.viewer.setBackgroundImage(null, false);
            } else if (mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
                if (!this.disableGeolocationBackground) {
                    this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(mapObject.getBackground()), mapObject.isCenterBackgroundImage());
                }
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(mapObject.getBackground()), mapObject.isCenterBackgroundImage());
            }
        }
        this.viewer.setBackgroundColor(ColorConverter.rgbFromInt((int)mapObject.getBackgroundColor()));
        this.setConnectionRouter(mapObject.getDefaultLinkRouting(), false);
        if (this.defaultLinkColor != null) {
            this.defaultLinkColor.dispose();
        }
        this.defaultLinkColor = mapObject.getDefaultLinkColor() >= 0 ? new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)mapObject.getDefaultLinkColor())) : null;
        this.labelProvider.setDefaultLinkColor(this.defaultLinkColor);
        if (mapObject.getBackground() != null && mapObject.getBackground().compareTo(NXCommon.EMPTY_GUID) != 0) {
            if (mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
                if (!this.disableGeolocationBackground) {
                    this.viewer.setBackgroundImage(mapObject.getBackgroundLocation(), mapObject.getBackgroundZoom());
                }
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(mapObject.getBackground()), mapObject.isCenterBackgroundImage());
            }
        }
        this.setLayoutAlgorithm(mapObject.getLayout(), false);
        this.setObjectDisplayMode(mapObject.getObjectDisplayMode(), false);
        this.labelProvider.setShowStatusBackground(mapObject.isShowStatusBackground());
        this.labelProvider.setShowStatusFrame(mapObject.isShowStatusFrame());
        this.labelProvider.setShowStatusIcons(mapObject.isShowStatusIcon());
        this.labelProvider.setShowLinkDirection(mapObject.isShowLinkDirection());
        this.labelProvider.setTranslucentLabelBackground(mapObject.isTranslucentLabelBackground());
        this.actionShowStatusBackground.setChecked(this.labelProvider.isShowStatusBackground());
        this.actionShowStatusFrame.setChecked(this.labelProvider.isShowStatusFrame());
        this.actionShowStatusIcon.setChecked(this.labelProvider.isShowStatusIcons());
        this.actionShowLinkDirection.setChecked(this.labelProvider.isShowLinkDirection());
        this.actionTranslucentLabelBkgnd.setChecked(this.labelProvider.isTranslucentLabelBackground());
        this.syncObjects();
    }

    private void addDCIContainer() {
        NetworkMapDCIContainer dciContainer = new NetworkMapDCIContainer(this.mapPage.createElementId());
        if (this.showDCIContainerProperties(dciContainer)) {
            this.mapPage.addElement((NetworkMapElement)dciContainer);
            this.saveMap();
            this.addDciToRequestList();
        }
    }

    private void editDCIContainer() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDCIContainer)) {
            return;
        }
        if (this.showDCIContainerProperties((NetworkMapDCIContainer)selection.getFirstElement())) {
            this.saveMap();
        }
    }

    private boolean showDCIContainerProperties(NetworkMapDCIContainer container) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("dciContainer.general", (IPreferencePage)new DCIContainerGeneral(container)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("dciContainer.dataSources", (IPreferencePage)new DCIContainerDataSources(container)));
        PropertyDialog dlg = new PropertyDialog(this.getWindow().getShell(), pm, i18n.tr("DCI Container Properties"));
        return dlg.open() == 0;
    }

    private void addDCIImage() {
        NetworkMapDCIImage dciImage = new NetworkMapDCIImage(this.mapPage.createElementId());
        if (this.showDCIImageProperties(dciImage)) {
            this.mapPage.addElement((NetworkMapElement)dciImage);
            this.saveMap();
            this.addDciToRequestList();
        }
    }

    private void editDCIImage() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDCIImage)) {
            return;
        }
        if (this.showDCIImageProperties((NetworkMapDCIImage)selection.getFirstElement())) {
            this.saveMap();
        }
    }

    private boolean showDCIImageProperties(NetworkMapDCIImage dciImage) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("dciImage.general", (IPreferencePage)new DCIImageGeneral(dciImage)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("dciImage.rules", (IPreferencePage)new DCIImageRules(dciImage)));
        PropertyDialog dlg = new PropertyDialog(this.getWindow().getShell(), pm, i18n.tr("DCI Image Properties"));
        return dlg.open() == 0;
    }

    private void linkSelectedObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 2) {
            return;
        }
        Object[] objects = selection.toArray();
        long id1 = ((NetworkMapObject)objects[0]).getId();
        long id2 = ((NetworkMapObject)objects[1]).getId();
        this.mapPage.addLink(new NetworkMapLink(this.mapPage.createLinkId(), 0, id1, id2));
        this.saveMap();
    }

    private void showLinkProperties() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapLink)) {
            return;
        }
        LinkEditor link = new LinkEditor((NetworkMapLink)selection.getFirstElement(), this.mapPage);
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("link.general", (IPreferencePage)new LinkGeneral(link)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("link.dataSources", (IPreferencePage)new LinkDataSources(link)));
        22 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        dlg.open();
        if (link.isModified()) {
            this.saveMap();
        }
    }

    private void addTextBox() {
        NetworkMapTextBox textBox = new NetworkMapTextBox(this.mapPage.createElementId());
        if (this.showTextBoxProperties(textBox)) {
            this.mapPage.addElement((NetworkMapElement)textBox);
            this.saveMap();
        }
    }

    private void editTextBox() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapTextBox)) {
            return;
        }
        if (this.showTextBoxProperties((NetworkMapTextBox)selection.getFirstElement())) {
            this.saveMap();
        }
    }

    private boolean showTextBoxProperties(NetworkMapTextBox textBox) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("textbox.general", (IPreferencePage)new TextBoxGeneral(textBox)));
        PropertyDialog dlg = new PropertyDialog(this.getWindow().getShell(), pm, i18n.tr("Text Box Properties"));
        return dlg.open() == 0;
    }

    private void addImageDecoration() {
        ImageSelectionDialog dlg = new ImageSelectionDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        UUID imageGuid = dlg.getImageGuid();
        Rectangle imageBounds = ImageProvider.getInstance().getImage(imageGuid).getBounds();
        NetworkMapDecoration element = new NetworkMapDecoration(this.mapPage.createElementId(), 1);
        element.setSize(imageBounds.width, imageBounds.height);
        element.setTitle(imageGuid.toString());
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void editImageDecoration() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDecoration)) {
            return;
        }
        ImageSelectionDialog dlg = new ImageSelectionDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        UUID imageGuid = dlg.getImageGuid();
        Rectangle imageBounds = ImageProvider.getInstance().getImage(imageGuid).getBounds();
        NetworkMapDecoration element = (NetworkMapDecoration)selection.getFirstElement();
        element.setSize(imageBounds.width, imageBounds.height);
        element.setTitle(imageGuid.toString());
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void addGroupBox() {
        NetworkMapDecoration element = new NetworkMapDecoration(this.mapPage.createElementId(), 0);
        EditGroupBoxDialog dlg = new EditGroupBoxDialog(this.getWindow().getShell(), element);
        if (dlg.open() != 0) {
            return;
        }
        this.mapPage.addElement((NetworkMapElement)element);
        this.saveMap();
    }

    private void editGroupBox() {
        this.updateObjectPositions();
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1 || !(selection.getFirstElement() instanceof NetworkMapDecoration)) {
            return;
        }
        NetworkMapDecoration groupBox = (NetworkMapDecoration)selection.getFirstElement();
        EditGroupBoxDialog dlg = new EditGroupBoxDialog(this.getWindow().getShell(), groupBox);
        if (dlg.open() == 0) {
            this.mapPage.addElement((NetworkMapElement)groupBox);
            this.saveMap();
        }
    }

    protected NetworkMap getMapObject() {
        return (NetworkMap)this.getObject();
    }

    protected void onObjectUpdate(AbstractObject object) {
        super.onObjectUpdate(object);
        this.onObjectChange(object);
    }

    static /* synthetic */ void access$000(PredefinedMapView x0) {
        x0.updateToolBar();
    }

    static /* synthetic */ void access$100(PredefinedMapView x0) {
        x0.updateMenu();
    }

    static /* synthetic */ NXCSession access$200(PredefinedMapView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$300(PredefinedMapView x0) {
        return x0.session;
    }
}

