/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Rack;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class RackProperties
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(RackProperties.class);
    private Rack rack;
    private LabeledSpinner rackHeight;
    private Combo numberingScheme;

    public RackProperties(AbstractObject object) {
        super(i18n.tr("Rack"), object);
    }

    public String getId() {
        return "rackProperties";
    }

    public int getPriority() {
        return 1;
    }

    public boolean isVisible() {
        return this.object instanceof Rack;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.rack = (Rack)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.rackHeight = new LabeledSpinner(dialogArea, 0);
        this.rackHeight.setLabel(i18n.tr("Height"));
        this.rackHeight.setRange(1, 50);
        this.rackHeight.setSelection(this.rack.getHeight());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.rackHeight.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.numberingScheme = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)i18n.tr("Numbering"), (Object)gd);
        this.numberingScheme.add(i18n.tr("Bottom to top"));
        this.numberingScheme.add(i18n.tr("Top to bottom"));
        this.numberingScheme.select(this.rack.isTopBottomNumbering() ? 1 : 0);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.rack.getObjectId());
        md.setHeight(this.rackHeight.getSelection());
        md.setRackNumberingTopBottom(this.numberingScheme.getSelectionIndex() == 1);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.rackHeight.setSelection(42);
        this.numberingScheme.select(0);
    }
}

