/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectTableView;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.NodeSubObjectFilter;
import org.netxms.nxmc.tools.WidgetHelper;

public abstract class NodeSubObjectTableView
extends NodeSubObjectView {
    protected SortableTableViewer viewer;
    protected NodeSubObjectFilter filter;
    protected Action actionCopyToClipboard;
    protected Action actionExportToCsv;

    public NodeSubObjectTableView(String name, ImageDescriptor image, String id, boolean hasFilters) {
        super(name, image, id, hasFilters);
    }

    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.createViewer();
        this.createActions();
        this.createPopupMenu();
    }

    protected abstract void createViewer();

    protected void createActions() {
        this.actionCopyToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
    }

    protected void createPopupMenu() {
        2 menuMgr = new /* Unavailable Anonymous Inner Class!! */;
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected abstract void fillContextMenu(IMenuManager var1);

    protected void copyToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = SystemUtils.IS_OS_WINDOWS ? "\r\n" : "\n";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    for (int j = 0; j < this.viewer.getTable().getColumnCount(); ++j) {
                        if (j > 0) {
                            sb.append('\t');
                        }
                        sb.append(selection[i].getText(j));
                    }
                    continue;
                }
                sb.append(selection[i].getText(column));
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }
}

