/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServiceRoot;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DashboardGroup;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.NetworkMapGroup;
import org.netxms.client.objects.NetworkMapRoot;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.SubtreeType;
import org.netxms.nxmc.modules.objects.views.ObjectBrowser;
import org.netxms.nxmc.modules.objects.widgets.ObjectTree;
import org.xnap.commons.i18n.I18n;

public class ObjectBrowser
extends NavigationView {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectBrowser.class);
    private SubtreeType subtreeType;
    private ObjectTree objectTree;

    public ObjectBrowser(String name, ImageDescriptor image, SubtreeType subtreeType) {
        super(name, image, "ObjectBrowser." + subtreeType.toString(), true, true, true);
        this.subtreeType = subtreeType;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.objectTree != null ? this.objectTree.getSelectionProvider() : null;
    }

    public void setSelection(Object selection) {
        this.objectTree.getTreeViewer().setSelection((ISelection)new StructuredSelection(selection));
        this.objectTree.getTreeViewer().reveal(selection);
    }

    protected void createContent(Composite parent) {
        this.objectTree = new ObjectTree(parent, 0, 2, this.calculateClassFilter(), (View)this, true, false);
        Menu menu = new ObjectContextMenuManager((View)this, this.objectTree.getSelectionProvider(), (ColumnViewer)this.objectTree.getTreeViewer()).createContextMenu((Control)this.objectTree.getTreeControl());
        this.objectTree.getTreeControl().setMenu(menu);
        this.objectTree.enableDropSupport(this);
        this.objectTree.enableDragSupport();
        TreeViewer treeViewer = this.objectTree.getTreeViewer();
        TreeViewerEditor.create((TreeViewer)treeViewer, (ColumnViewerEditorActivationStrategy)new /* Unavailable Anonymous Inner Class!! */, (int)1);
        TextCellEditor editor = new TextCellEditor((Composite)treeViewer.getTree(), 2048);
        editor.addListener((ICellEditorListener)new /* Unavailable Anonymous Inner Class!! */);
        treeViewer.setCellEditors(new CellEditor[]{editor});
        treeViewer.setColumnProperties(new String[]{"name"});
        treeViewer.setCellModifier((ICellModifier)new /* Unavailable Anonymous Inner Class!! */);
        this.objectTree.getTreeViewer().expandToLevel(2);
    }

    private Set<Integer> calculateClassFilter() {
        HashSet<Integer> classFilter = new HashSet<Integer>();
        switch (5.$SwitchMap$org$netxms$nxmc$modules$objects$SubtreeType[this.subtreeType.ordinal()]) {
            case 1: {
                classFilter.add(7);
                classFilter.add(5);
                classFilter.add(14);
                classFilter.add(35);
                classFilter.add(32);
                classFilter.add(2);
                classFilter.add(3);
                classFilter.add(33);
                classFilter.add(12);
                classFilter.add(11);
                classFilter.add(13);
                classFilter.add(31);
                classFilter.add(37);
                break;
            }
            case 2: {
                classFilter.add(21);
                classFilter.add(20);
                classFilter.add(19);
                break;
            }
            case 3: {
                classFilter.add(14);
                classFilter.add(4);
                classFilter.add(6);
                classFilter.add(1);
                classFilter.add(2);
                classFilter.add(3);
                classFilter.add(33);
                classFilter.add(12);
                classFilter.add(11);
                break;
            }
            case 4: {
                classFilter.add(8);
                classFilter.add(9);
                classFilter.add(10);
                break;
            }
            case 5: {
                classFilter.add(23);
                classFilter.add(36);
                classFilter.add(22);
                break;
            }
            case 6: {
                classFilter.add(28);
                classFilter.add(15);
                classFilter.add(27);
            }
        }
        return classFilter;
    }

    public boolean isValidSelectionForMove(SubtreeType subtree) {
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        if (selection.length < 1) {
            return false;
        }
        for (int i = 0; i < selection.length; ++i) {
            if (this.isValidObjectForMove(selection, i, subtree) && ((AbstractObject)selection[0].getParentItem().getData()).getObjectId() == ((AbstractObject)selection[i].getParentItem().getData()).getObjectId()) continue;
            return false;
        }
        return true;
    }

    public boolean isValidObjectForMove(TreeItem[] selection, int i, SubtreeType subtree) {
        if (selection[i].getParentItem() == null) {
            return false;
        }
        AbstractObject currentObject = (AbstractObject)selection[i].getData();
        AbstractObject parentObject = (AbstractObject)selection[i].getParentItem().getData();
        switch (5.$SwitchMap$org$netxms$nxmc$modules$objects$SubtreeType[subtree.ordinal()]) {
            case 1: {
                return !(!(currentObject instanceof Node) && !(currentObject instanceof Cluster) && !(currentObject instanceof Subnet) && !(currentObject instanceof Condition) && !(currentObject instanceof Rack) && !(currentObject instanceof MobileDevice) && !(currentObject instanceof Container) && !(currentObject instanceof Sensor) || !(parentObject instanceof Container) && !(parentObject instanceof ServiceRoot));
            }
            case 4: {
                return !(!(currentObject instanceof Template) && !(currentObject instanceof TemplateGroup) || !(parentObject instanceof TemplateGroup) && !(parentObject instanceof TemplateRoot));
            }
            case 6: {
                return currentObject instanceof BusinessService && (parentObject instanceof BusinessService || parentObject instanceof BusinessServiceRoot);
            }
            case 2: {
                return !(!(currentObject instanceof NetworkMap) && !(currentObject instanceof NetworkMapGroup) || !(parentObject instanceof NetworkMapGroup) && !(parentObject instanceof NetworkMapRoot));
            }
            case 5: {
                return !(!(currentObject instanceof Dashboard) && !(currentObject instanceof DashboardGroup) || !(parentObject instanceof DashboardRoot) && !(parentObject instanceof DashboardGroup) && !(parentObject instanceof Dashboard));
            }
        }
        return false;
    }

    public void moveObject(AbstractObject destination, AbstractObject source, AbstractObject movableObject, boolean move) {
        if (destination.getObjectId() == source.getObjectId()) {
            return;
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

