/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.xnap.commons.i18n.I18n;

public class ObjectList
extends Composite {
    private I18n i18n = LocalizationHelper.getI18n(ObjectList.class);
    private TableViewer viewer;
    private HashMap<Long, AbstractObject> objects = new HashMap();
    private Button addButton;
    private Button deleteButton;

    public ObjectList(Composite parent, int style, String title, Collection<AbstractObject> initialContent, Class<? extends AbstractObject> classFilter, Set<Integer> selectionTreeFilter, Runnable modifyListener) {
        super(parent, style);
        if (initialContent != null) {
            for (AbstractObject o : initialContent) {
                this.objects.put(o.getObjectId(), o);
            }
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        if (title != null) {
            Label titleLabel = new Label((Composite)this, 0);
            titleLabel.setText(title);
        }
        this.viewer = new TableViewer((Composite)this, 67586);
        this.viewer.getTable().setSortDirection(128);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingObjectLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.setInput((Object)this.objects.values().toArray());
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)this, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.verticalIndent = 2;
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(this.i18n.tr("Delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
    }

    public void clear() {
        this.objects.clear();
        this.viewer.setInput((Object)new AbstractObject[0]);
    }

    public Long[] getObjectIdentifiers() {
        return this.objects.keySet().toArray(new Long[this.objects.size()]);
    }

    public List<AbstractObject> getObjects() {
        return new ArrayList<AbstractObject>(this.objects.values());
    }
}

