/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.dialogs;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.dialogs.DialogWithFilter;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.dialogs.UserSelectionDialog;
import org.netxms.nxmc.modules.users.dialogs.helpers.UserListFilter;
import org.netxms.nxmc.modules.users.views.helpers.BaseUserLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class UserSelectionDialog
extends DialogWithFilter {
    private I18n i18n = LocalizationHelper.getI18n(UserSelectionDialog.class);
    private TableViewer userList;
    private NXCSession session;
    private Class<? extends AbstractUserObject> classFilter;
    private boolean multiSelection = true;
    private AbstractUserObject[] selection;

    public UserSelectionDialog(Shell parentShell, Class<? extends AbstractUserObject> classFilter) {
        super(parentShell);
        this.classFilter = classFilter;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.i18n.tr("Select User"));
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.session = Registry.getSession();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.userList = new TableViewer(dialogArea, 0x800 | (this.multiSelection ? 2 : 0) | 0x10000);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        BaseUserLabelProvider labelProvider = new BaseUserLabelProvider();
        this.userList.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.userList.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.userList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        UserListFilter filter = new UserListFilter(labelProvider);
        this.userList.addFilter((ViewerFilter)filter);
        this.userList.setInput((Object)this.getFilteredUserDatabaseObjects());
        this.setFilterClient((StructuredViewer)this.userList, (AbstractViewerFilter)filter);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 600;
        this.userList.getControl().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.getUsersAndRefresh();
        return content;
    }

    private Object[] getFilteredUserDatabaseObjects() {
        return Arrays.asList(this.session.getUserDatabaseObjects()).stream().filter(o -> this.classFilter == null || this.classFilter.isInstance(o)).toArray();
    }

    private void getUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        this.userList.setInput((Object)new String[]{"Loading..."});
        this.getButton(0).setEnabled(false);
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.userList.getSelection();
        if (sel.size() == 0) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("You must select at least one user from list and then press OK."));
            return;
        }
        this.selection = new AbstractUserObject[sel.size()];
        Iterator it = sel.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.selection[i] = (AbstractUserObject)it.next();
            ++i;
        }
        super.okPressed();
    }

    public AbstractUserObject[] getSelection() {
        return this.selection;
    }

    static /* synthetic */ Button access$000(UserSelectionDialog x0, int x1) {
        return x0.getButton(x1);
    }

    static /* synthetic */ Button access$100(UserSelectionDialog x0, int x1) {
        return x0.getButton(x1);
    }
}

