/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;

public class FilterText
extends Composite {
    private Text text;
    private Composite buttonArea;
    private Composite textArea;
    private List<Button> attrButtons = new ArrayList<Button>(4);
    private Label closeButton;
    private Label clearButton;
    private Action closeAction = null;
    private boolean autoApply = true;
    private int delay = 300;
    private int minLength = 1;
    private Set<ModifyListener> modifyListeners = new HashSet<ModifyListener>();
    private ModifyEvent lastModifyEvent = null;
    private IContentProposalProvider proposalProvider = null;
    private ContentProposalAdapter proposalAdapter = null;

    public FilterText(Composite parent, int style) {
        this(parent, style, null, true, true, null);
    }

    public FilterText(Composite parent, int style, String tooltip, boolean showFilterCloseButton) {
        this(parent, style, tooltip, showFilterCloseButton, true, null);
    }

    public FilterText(Composite parent, int style, String tooltip, boolean showFilterCloseButton, boolean showFilterLabel) {
        this(parent, style, tooltip, showFilterCloseButton, showFilterLabel, null);
    }

    public FilterText(Composite parent, int style, String tooltip, boolean showFilterCloseButton, boolean showFilterLabel, IContentProposalProvider proposalProvider) {
        super(parent, style);
        GridData gd;
        GridLayout layout = new GridLayout();
        layout.numColumns = showFilterLabel ? 5 : 4;
        this.setLayout((Layout)layout);
        if (showFilterLabel) {
            Label label = new Label((Composite)this, 0);
            Messages.get();
            label.setText(Messages.FilterText_Filter);
            gd = new GridData();
            gd.verticalAlignment = 0x1000000;
            label.setLayoutData((Object)gd);
        }
        this.textArea = new Composite((Composite)this, 2048);
        GridLayout textLayout = new GridLayout();
        textLayout.numColumns = 2;
        textLayout.marginBottom = 0;
        textLayout.marginTop = 0;
        textLayout.marginLeft = 0;
        textLayout.marginRight = 0;
        this.textArea.setLayout((Layout)textLayout);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.textArea.setLayoutData((Object)gd);
        this.text = new Text(this.textArea, 4);
        this.text.setTextLimit(64);
        Messages.get();
        this.text.setMessage(Messages.FilterText_FilterIsEmpty);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(final ModifyEvent e) {
                int l;
                FilterText.this.lastModifyEvent = e;
                if (!FilterText.this.autoApply) {
                    return;
                }
                if (FilterText.this.minLength > 1 && (l = FilterText.this.text.getText().length()) < FilterText.this.minLength && l > 0) {
                    return;
                }
                if (FilterText.this.delay > 0) {
                    FilterText.this.getDisplay().timerExec(FilterText.this.delay, new Runnable(){

                        @Override
                        public void run() {
                            if ((this).FilterText.this.text.isDisposed()) {
                                return;
                            }
                            if ((this).FilterText.this.lastModifyEvent == e) {
                                FilterText.this.callModifyListeners(e);
                            }
                        }
                    });
                } else {
                    FilterText.this.callModifyListeners(e);
                }
            }
        });
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    FilterText.this.callModifyListeners(FilterText.this.lastModifyEvent);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        if (tooltip != null) {
            Label icon = new Label(this.textArea, 0);
            icon.setImage(SharedIcons.IMG_INFORMATION);
            gd = new GridData();
            gd.verticalAlignment = 0x1000000;
            icon.setLayoutData((Object)gd);
            icon.setToolTipText(tooltip);
            icon.setBackground(this.text.getBackground());
        }
        this.textArea.setBackground(this.text.getBackground());
        if (proposalProvider != null) {
            this.proposalProvider = proposalProvider;
            this.enableAutoComplete();
        }
        this.buttonArea = new Composite((Composite)this, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.wrap = true;
        buttonLayout.marginBottom = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.spacing = 4;
        buttonLayout.pack = false;
        this.buttonArea.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.buttonArea.setLayoutData((Object)gd);
        this.clearButton = new Label((Composite)this, 0);
        this.clearButton.setBackground(this.getBackground());
        this.clearButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.clearButton.setImage(SharedIcons.IMG_CLEAR);
        Messages.get();
        this.clearButton.setToolTipText(Messages.FilterText_Clear);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.clearButton.setLayoutData((Object)gd);
        this.clearButton.addMouseListener(new MouseListener(){
            private boolean doAction = false;

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = false;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && this.doAction) {
                    FilterText.this.clearFilter();
                }
            }
        });
        if (showFilterCloseButton) {
            this.closeButton = new Label((Composite)this, 0);
            this.closeButton.setBackground(this.getBackground());
            this.closeButton.setCursor(this.getDisplay().getSystemCursor(21));
            this.closeButton.setImage(SharedIcons.IMG_CLOSE);
            Messages.get();
            this.closeButton.setToolTipText(Messages.FilterText_CloseFilter);
            gd = new GridData();
            gd.verticalAlignment = 0x1000000;
            this.closeButton.setLayoutData((Object)gd);
            this.closeButton.addMouseListener(new MouseListener(){
                private boolean doAction = false;

                public void mouseDoubleClick(MouseEvent e) {
                    if (e.button == 1) {
                        this.doAction = false;
                    }
                }

                public void mouseDown(MouseEvent e) {
                    if (e.button == 1) {
                        this.doAction = true;
                    }
                }

                public void mouseUp(MouseEvent e) {
                    if (e.button == 1 && this.doAction) {
                        FilterText.this.closeFilter();
                    }
                }
            });
        }
    }

    private void enableAutoComplete() {
        this.proposalAdapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), this.proposalProvider, null, null);
        this.proposalAdapter.setPropagateKeys(true);
        this.proposalAdapter.setProposalAcceptanceStyle(3);
        this.proposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                String content = FilterText.this.text.getText();
                if (content.isEmpty()) {
                    FilterText.this.text.append(proposal.getContent());
                    return;
                }
                int pos = FilterText.this.text.getCaretPosition() - 1;
                while (pos > 0 && !FilterText.isStopCharacter(content.charAt(pos))) {
                    --pos;
                }
                FilterText.this.text.setSelection(FilterText.isStopCharacter(content.charAt(pos)) ? pos + 1 : pos, FilterText.this.text.getCaretPosition());
                FilterText.this.text.insert(proposal.getContent());
            }
        });
    }

    private static boolean isStopCharacter(char ch) {
        return ch == ':' || ch == ',' || Character.isWhitespace(ch);
    }

    private void clearFilter() {
        if (!this.text.getText().equals("")) {
            this.text.setText("");
        }
        if (!this.autoApply) {
            this.callModifyListeners(this.lastModifyEvent);
        }
    }

    private void closeFilter() {
        if (this.closeAction != null) {
            this.closeAction.run();
        }
    }

    public void setAttributeList(String[] attributes) {
        for (Button b : this.attrButtons) {
            b.dispose();
        }
        this.attrButtons.clear();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            final Button b = new Button(this.buttonArea, 2);
            b.setText(attr);
            this.attrButtons.add(b);
            b.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FilterText.this.onAttrButtonSelection(b);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            ++n2;
        }
        this.layout(true, true);
    }

    private void onAttrButtonSelection(Button b) {
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    private void callModifyListeners(ModifyEvent e) {
        for (ModifyListener l : this.modifyListeners) {
            l.modifyText(e);
        }
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String value) {
        this.text.setText(value);
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    public void setCloseAction(Action closeAction) {
        this.closeAction = closeAction;
    }

    public boolean setFocus() {
        if (this.text.isDisposed()) {
            return false;
        }
        return this.text.setFocus();
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean isAutoApply() {
        return this.autoApply;
    }

    public void setAutoApply(boolean autoApply) {
        this.autoApply = autoApply;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.closeButton != null) {
            this.closeButton.setBackground(color);
        }
        if (this.clearButton != null) {
            this.clearButton.setBackground(color);
        }
    }
}

