/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.propertypages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.propertypages.helpers.EventTemplateLabelProvider;
import org.netxms.ui.eclipse.epp.widgets.RuleEditor;
import org.netxms.ui.eclipse.eventmanager.dialogs.EventSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ElementLabelComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RuleEvents
extends PropertyPage {
    private NXCSession session;
    private RuleEditor editor;
    private EventProcessingPolicyRule rule;
    private SortableTableViewer viewer;
    private Map<Long, EventTemplate> events = new HashMap<Long, EventTemplate>();
    private Button addButton;
    private Button deleteButton;
    private Button checkInverted;

    protected Control createContents(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        this.editor = (RuleEditor)((Object)this.getElement().getAdapter(RuleEditor.class));
        this.rule = this.editor.getRule();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkInverted = new Button(dialogArea, 32);
        Messages.get();
        this.checkInverted.setText(Messages.RuleEvents_InvertedRule);
        this.checkInverted.setSelection(this.rule.isEventsInverted());
        String[] stringArray = new String[1];
        Messages.get();
        stringArray[0] = Messages.RuleEvents_Event;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{300};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EventTemplateLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)RuleEvents.this.viewer.getSelection()).size();
                RuleEvents.this.deleteButton.setEnabled(size > 0);
            }
        });
        for (EventTemplate o : this.session.findMultipleEventTemplates((Collection)this.rule.getEvents())) {
            this.events.put(o.getCode(), o);
        }
        this.viewer.setInput((Object)this.events.values().toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        Messages.get();
        this.addButton.setText(Messages.RuleEvents_Add);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleEvents.this.addEvent();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.RuleEvents_Delete);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleEvents.this.deleteEvent();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        return dialogArea;
    }

    private void addEvent() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getShell());
        dlg.enableMultiSelection(true);
        if (dlg.open() == 0) {
            EventTemplate[] eventTemplateArray = dlg.getSelectedEvents();
            int n = eventTemplateArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventTemplate e = eventTemplateArray[n2];
                this.events.put(e.getCode(), e);
                ++n2;
            }
        }
        this.viewer.setInput((Object)this.events.values().toArray());
    }

    private void deleteEvent() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                EventTemplate e = (EventTemplate)it.next();
                this.events.remove(e.getCode());
            }
            this.viewer.setInput((Object)this.events.values().toArray());
        }
    }

    private void doApply() {
        int flags = this.rule.getFlags();
        flags = this.checkInverted.getSelection() && !this.events.isEmpty() ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        this.rule.setFlags(flags);
        this.rule.setEvents(new ArrayList<Long>(this.events.keySet()));
        this.editor.setModified(true);
    }

    protected void performApply() {
        this.doApply();
    }

    public boolean performOk() {
        this.doApply();
        return super.performOk();
    }
}

