/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.configs.CustomAttribute;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.objectmanager.dialogs.AttributeEditDialog;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.AttrListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ElementLabelComparator;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class CustomAttributes
extends PropertyPage {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_INHERITABLE = 2;
    public static final int COLUMN_INHERETED_FROM = 3;
    private AbstractObject object = null;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Map<String, CustomAttribute> attributes = null;
    private boolean isModified = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.CustomAttributes_Name;
        Messages.get();
        stringArray[1] = Messages.CustomAttributes_Value;
        stringArray[2] = "Inheritable";
        stringArray[3] = "Inherited From";
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{150, 250, 80, 250};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        AttrListLabelProvider labelProvider = new AttrListLabelProvider(this.object);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)labelProvider));
        this.attributes = new HashMap<String, CustomAttribute>(this.object.getCustomAttributes());
        this.viewer.setInput(this.attributes.entrySet());
        if (!Platform.getPreferencesService().getBoolean("org.netxms.ui.eclipse.console", "SHOW_HIDDEN_ATTRIBUTES", false, null)) {
            this.viewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !((String)((Map.Entry)element).getKey()).startsWith(".");
                }
            });
        }
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        Messages.get();
        this.addButton.setText(Messages.CustomAttributes_Add);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomAttributes.this.addAttribute();
            }
        });
        this.editButton = new Button(buttons, 8);
        Messages.get();
        this.editButton.setText(Messages.CustomAttributes_Modify);
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomAttributes.this.editAttribute();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.CustomAttributes_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomAttributes.this.deleteAttributes();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CustomAttributes.this.editAttribute();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CustomAttributes.this.viewer.getSelection();
                CustomAttributes.this.editButton.setEnabled(selection.size() == 1);
                CustomAttributes.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        return dialogArea;
    }

    private void addAttribute() {
        AttributeEditDialog dlg = new AttributeEditDialog(this.getShell(), null, null, 0L, 0L);
        if (dlg.open() != 0) {
            return;
        }
        if (this.attributes.containsKey(dlg.getName())) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.CustomAttributes_Warning, (String)String.format(Messages.CustomAttributes_WarningAlreadyExist, dlg.getName()));
        } else {
            this.attributes.put(dlg.getName(), new CustomAttribute(dlg.getValue(), dlg.getFlags(), 0L));
            this.viewer.setInput(this.attributes.entrySet());
            this.isModified = true;
        }
    }

    private void editAttribute() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry element = (Map.Entry)selection.getFirstElement();
        CustomAttribute attr = (CustomAttribute)element.getValue();
        AttributeEditDialog dlg = new AttributeEditDialog(this.getShell(), (String)element.getKey(), attr.getValue(), attr.getFlags(), attr.getSourceObject());
        if (dlg.open() == 0) {
            this.attributes.put(dlg.getName(), new CustomAttribute(dlg.getValue(), dlg.getFlags(), attr.getSourceObject()));
            this.viewer.setInput(this.attributes.entrySet());
            this.isModified = true;
        }
    }

    private void deleteAttributes() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        boolean modified = false;
        while (it.hasNext()) {
            Map.Entry element = (Map.Entry)it.next();
            if (((CustomAttribute)element.getValue()).isInherited() && !((CustomAttribute)element.getValue()).isRedefined()) continue;
            if (((CustomAttribute)element.getValue()).isRedefined()) {
                CustomAttribute ca;
                AbstractObject obj;
                boolean parentAttributeFound = false;
                AbstractObject[] abstractObjectArray = this.object.getParentsAsArray();
                int n = abstractObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    obj = abstractObjectArray[n2];
                    if (((CustomAttribute)element.getValue()).getSourceObject() == obj.getObjectId()) {
                        ca = obj.getCustomAttribute((String)element.getKey());
                        if (ca == null || !ca.isInheritable()) break;
                        this.attributes.put((String)element.getKey(), new CustomAttribute(ca.getValue(), 1L, ca.isInherited() && !ca.isRedefined() ? ca.getSourceObject() : obj.getObjectId()));
                        parentAttributeFound = true;
                        break;
                    }
                    ++n2;
                }
                if (!parentAttributeFound) {
                    abstractObjectArray = this.object.getParentsAsArray();
                    n = abstractObjectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        obj = abstractObjectArray[n2];
                        ca = obj.getCustomAttribute((String)element.getKey());
                        if (ca != null && ca.isInheritable()) {
                            this.attributes.put((String)element.getKey(), new CustomAttribute(ca.getValue(), 1L, ca.isInherited() && !ca.isRedefined() ? ca.getSourceObject() : obj.getObjectId()));
                            parentAttributeFound = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!parentAttributeFound) {
                    this.attributes.remove(element.getKey());
                }
                modified = true;
                continue;
            }
            this.attributes.remove(element.getKey());
            modified = true;
        }
        if (modified) {
            this.viewer.setInput(this.attributes.entrySet());
            this.isModified = true;
        }
    }

    protected void applyChanges(final boolean isApply) {
        if (!this.isModified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setCustomAttributes(this.attributes);
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.CustomAttributes_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                CustomAttributes.this.isModified = false;
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.CustomAttributes_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            CustomAttributes.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

