/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serviceview.widgets.helpers;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;
import org.netxms.ui.eclipse.serviceview.widgets.helpers.IServiceFigureListener;
import org.netxms.ui.eclipse.serviceview.widgets.helpers.ServiceTreeElement;
import org.netxms.ui.eclipse.serviceview.widgets.helpers.ServiceTreeLabelProvider;

public class ServiceFigure
extends Figure {
    private static final int INNER_SPACING = 5;
    private static final int HORIZONTAL_MARGIN = 4;
    private static final int VERTICAL_MARGIN = 4;
    private static final int MAX_LABEL_WIDTH = 70;
    private static final Color BORDER_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color NORMAL_COLOR_LEFT = new Color((Device)Display.getCurrent(), 164, 196, 212);
    private static final Color NORMAL_COLOR_RIGHT = new Color((Device)Display.getCurrent(), 180, 208, 228);
    private static final Color SELECTION_COLOR_LEFT = new Color((Device)Display.getCurrent(), 255, 242, 0);
    private static final Color SELECTION_COLOR_RIGHT = new Color((Device)Display.getCurrent(), 225, 212, 0);
    private ServiceTreeElement service;
    private ServiceTreeLabelProvider labelProvider;
    private IServiceFigureListener listener;
    private Label expandBox;
    private Label label;

    public ServiceFigure(ServiceTreeElement service, ServiceTreeLabelProvider labelProvider, IServiceFigureListener listener) {
        this.service = service;
        this.labelProvider = labelProvider;
        this.listener = listener;
        this.label = new Label(service.getObject().getObjectName());
        this.label.setFont(labelProvider.getFont());
        this.label.setLabelAlignment(2);
        this.label.setIcon(labelProvider.getImage(service));
        this.label.setMaximumSize(new Dimension(70, -1));
        this.add((IFigure)this.label, BorderLayout.LEFT);
        this.expandBox = new Label("");
        this.expandBox.setFont(labelProvider.getFont());
        this.expandBox.setIcon(labelProvider.getExpansionStatusIcon(service));
        this.expandBox.setIconAlignment(1);
        this.add((IFigure)this.expandBox, BorderLayout.RIGHT);
        if (listener != null) {
            this.label.addMouseListener(new MouseListener(){

                public void mouseDoubleClicked(MouseEvent me) {
                    if (me.button == 1) {
                        ServiceFigure.this.listener.expandButtonPressed(ServiceFigure.this.service);
                    }
                }

                public void mousePressed(MouseEvent me) {
                }

                public void mouseReleased(MouseEvent me) {
                }
            });
            this.expandBox.addMouseListener(new MouseListener(){

                public void mouseDoubleClicked(MouseEvent me) {
                }

                public void mousePressed(MouseEvent me) {
                }

                public void mouseReleased(MouseEvent me) {
                    if (me.button == 1) {
                        ServiceFigure.this.listener.expandButtonPressed(ServiceFigure.this.service);
                    }
                }
            });
        }
        Dimension ls = this.label.getPreferredSize(70, -1);
        Dimension es = this.expandBox.getPreferredSize(-1, -1);
        this.label.setSize(ls);
        this.expandBox.setSize(es);
        int width = ls.width + es.width + 5 + 8;
        int height = ls.height + 8;
        this.setSize(width, height);
        this.label.setLocation(new Point(4, 4));
        this.expandBox.setLocation(new Point(width - 4 - es.width, height / 2 - es.height / 2));
    }

    protected void paintFigure(Graphics gc) {
        Rectangle rect = new Rectangle(this.getBounds());
        --rect.height;
        --rect.width;
        gc.setAntialias(1);
        if (this.labelProvider.isElementSelected(this.service)) {
            Pattern pattern = new Pattern((Device)Display.getDefault(), (float)rect.x, (float)rect.y, (float)(rect.x + rect.width), (float)(rect.y + rect.height), SELECTION_COLOR_LEFT, SELECTION_COLOR_RIGHT);
            gc.setBackgroundPattern(pattern);
            gc.fillRoundRectangle(rect, 8, 8);
            pattern.dispose();
        } else {
            Pattern pattern = new Pattern((Device)Display.getDefault(), (float)rect.x, (float)rect.y, (float)(rect.x + rect.width), (float)(rect.y + rect.height), NORMAL_COLOR_LEFT, NORMAL_COLOR_RIGHT);
            gc.setBackgroundPattern(pattern);
            gc.fillRoundRectangle(rect, 8, 8);
        }
        gc.setLineWidth(1);
        gc.setForegroundColor(BORDER_COLOR);
        gc.drawRoundRectangle(rect, 8, 8);
    }
}

