/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.internal;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class LastValuesComparator
extends ViewerComparator {
    private boolean showErrors = true;
    private NXCSession session = ConsoleSharedData.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        DciValue v1 = (DciValue)e1;
        DciValue v2 = (DciValue)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 0: {
                result = (int)(v1.getId() - v2.getId());
                break;
            }
            case 1: {
                result = v1.getDescription().compareToIgnoreCase(v2.getDescription());
                break;
            }
            case 2: {
                result = this.compareValue(v1, v2);
                break;
            }
            case 5: {
                result = this.getEventName(v1).compareToIgnoreCase(this.getEventName(v2));
                break;
            }
            case 3: {
                result = v1.getTimestamp().compareTo(v2.getTimestamp());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    public String getEventName(DciValue value) {
        Threshold threshold = value.getActiveThreshold();
        if (threshold == null) {
            return "";
        }
        return this.session.getEventName((long)threshold.getFireEvent());
    }

    private int compareValue(DciValue dci1, DciValue dci2) {
        String v2;
        DataType dt2;
        String v1;
        DataType dt1;
        if (this.showErrors && dci1.getErrorCount() > 0) {
            dt1 = DataType.STRING;
            Messages.get();
            v1 = Messages.LastValuesLabelProvider_Error;
        } else if (dci1.getDcObjectType() == 2) {
            dt1 = DataType.STRING;
            Messages.get();
            v1 = Messages.LastValuesLabelProvider_Table;
        } else {
            dt1 = dci1.getDataType();
            v1 = dci1.getValue();
        }
        if (this.showErrors && dci2.getErrorCount() > 0) {
            dt2 = DataType.STRING;
            Messages.get();
            v2 = Messages.LastValuesLabelProvider_Error;
        } else if (dci2.getDcObjectType() == 2) {
            dt2 = DataType.STRING;
            Messages.get();
            v2 = Messages.LastValuesLabelProvider_Table;
        } else {
            dt2 = dci2.getDataType();
            v2 = dci2.getValue();
        }
        DataType dataType = DataType.getTypeForCompare((DataType)dt1, (DataType)dt2);
        try {
            switch (dataType) {
                case INT32: {
                    return Integer.signum(Integer.parseInt(v1) - Integer.parseInt(v2));
                }
                case UINT32: 
                case INT64: 
                case UINT64: 
                case COUNTER32: 
                case COUNTER64: {
                    return Long.signum(Long.parseLong(v1) - Long.parseLong(v2));
                }
                case FLOAT: {
                    return (int)Math.signum(Double.parseDouble(v1) - Double.parseDouble(v2));
                }
            }
            return v1.compareToIgnoreCase(v2);
        }
        catch (NumberFormatException e) {
            return v1.compareToIgnoreCase(v2);
        }
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }
}

