/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.packages;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.netxms.base.NXCPMessage;

public class PackageInfo {
    private long id;
    private String name;
    private String description;
    private String fileName;
    private String type;
    private String platform;
    private String version;
    private String command;

    public PackageInfo(String name, String description, String fileName, String type, String platform, String version, String command) {
        this.id = 0L;
        this.name = name;
        this.description = description;
        this.fileName = fileName;
        this.type = type;
        this.platform = platform;
        this.version = version;
        this.command = command;
    }

    public PackageInfo(File npiFile) throws IOException {
        this.id = 0L;
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(npiFile));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("NAME ")) {
                    this.name = line.substring(5).trim();
                    continue;
                }
                if (line.startsWith("PLATFORM ")) {
                    this.platform = line.substring(9).trim();
                    continue;
                }
                if (line.startsWith("VERSION ")) {
                    this.version = line.substring(8).trim();
                    continue;
                }
                if (line.startsWith("DESCRIPTION ")) {
                    this.description = line.substring(12).trim();
                    continue;
                }
                if (!line.startsWith("FILE ")) continue;
                this.fileName = line.substring(5).trim();
            }
        }
        this.type = "agent-installer";
        this.command = "";
    }

    public PackageInfo(NXCPMessage msg) {
        this.id = msg.getFieldAsInt64(126L);
        this.name = msg.getFieldAsString(129L);
        this.description = msg.getFieldAsString(27L);
        this.fileName = msg.getFieldAsString(125L);
        this.type = msg.getFieldAsString(784L);
        this.platform = msg.getFieldAsString(128L);
        this.version = msg.getFieldAsString(127L);
        this.command = msg.getFieldAsString(145L);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(126L, (int)this.id);
        msg.setField(129L, this.name);
        msg.setField(27L, this.description);
        msg.setField(125L, this.fileName);
        msg.setField(784L, this.type);
        msg.setField(128L, this.platform);
        msg.setField(127L, this.version);
        msg.setField(145L, this.command);
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getType() {
        return this.type;
    }

    public String getCommand() {
        return this.command;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCommand(String command) {
        this.command = command;
    }
}

