/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.FdbEntry;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.Messages;

public class SwitchForwardingDatabaseFilter
extends ViewerFilter {
    private String filterString = null;
    private NXCSession session = ConsoleSharedData.getSession();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        FdbEntry en = (FdbEntry)element;
        if (this.containsMac(en)) {
            return true;
        }
        if (this.containsPort(en)) {
            return true;
        }
        if (this.containsInterface(en)) {
            return true;
        }
        if (this.containsVlan(en)) {
            return true;
        }
        if (this.containsNode(en)) {
            return true;
        }
        if (this.containsType(en)) {
            return true;
        }
        String vendor = this.session.getVendorByMac(en.getAddress(), null);
        return vendor != null && vendor.toLowerCase().contains(this.filterString);
    }

    private boolean containsType(FdbEntry en) {
        switch (en.getType()) {
            case 3: {
                Messages.get();
                if (!Messages.FDBLabelProvider_Dynamic.toLowerCase().contains(this.filterString)) break;
                return true;
            }
            case 5: {
                Messages.get();
                if (!Messages.FDBLabelProvider_Static.toLowerCase().contains(this.filterString)) break;
                return true;
            }
            default: {
                Messages.get();
                return Messages.FDBLabelProvider_Unknown.toLowerCase().contains(this.filterString);
            }
        }
        return false;
    }

    private boolean containsNode(FdbEntry en) {
        NXCSession session = ConsoleSharedData.getSession();
        return session.getObjectName(en.getNodeId()).toLowerCase().contains(this.filterString);
    }

    private boolean containsVlan(FdbEntry en) {
        return Integer.toString(en.getVlanId()).toLowerCase().contains(this.filterString);
    }

    private boolean containsInterface(FdbEntry en) {
        return en.getInterfaceName().toLowerCase().contains(this.filterString);
    }

    private boolean containsPort(FdbEntry en) {
        return Integer.toString(en.getPort()).toLowerCase().contains(this.filterString);
    }

    private boolean containsMac(FdbEntry en) {
        return en.getAddress().toString().toLowerCase().contains(this.filterString);
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }
}

