/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.api.GaugeColorMode;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.charts.widgets.GenericGauge;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class BarGauge
extends GenericGauge {
    private static final int MAX_BAR_THICKNESS = 40;
    private static final int SCALE_TEXT_HEIGHT = 16;
    private static final int SCALE_TEXT_WIDTH = 20;
    private Font[] scaleFonts = null;

    public BarGauge(Chart parent) {
        super(parent);
    }

    @Override
    protected void createFonts() {
        String fontName = this.chart.getConfiguration().getFontName();
        this.scaleFonts = new Font[16];
        int i = 0;
        while (i < this.scaleFonts.length) {
            this.scaleFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 0);
            ++i;
        }
    }

    @Override
    protected void disposeFonts() {
        if (this.scaleFonts != null) {
            int i = 0;
            while (i < this.scaleFonts.length) {
                this.scaleFonts[i].dispose();
                ++i;
            }
        }
    }

    @Override
    protected void renderElement(GC gc, ChartConfiguration config, Object renderData, GraphItem dci, DataSeries data, int x, int y, int w, int h) {
        double pointValue;
        Rectangle rect = new Rectangle(x + 5, y + 5, w - 10, h - 10);
        gc.setAntialias(1);
        if (config.isElementBordersVisible()) {
            gc.setForeground(this.getColorFromPreferences("Chart.Axis.Y.Color"));
            gc.drawRectangle(rect);
            rect.x += 5;
            rect.y += 5;
            rect.width -= 10;
            rect.height -= 10;
        }
        if (config.areLabelsVisible()) {
            gc.setForeground(this.getColorFromPreferences("Chart.Colors.Legend"));
            gc.setFont(null);
            Point legendExt = gc.textExtent(dci.getDescription());
            switch (config.getLegendPosition()) {
                case 4: {
                    gc.drawText(dci.getDescription(), rect.x + (rect.width - legendExt.x) / 2, rect.y + 4, true);
                    rect.y += legendExt.y + 8;
                    rect.height -= legendExt.y + 8;
                    break;
                }
                case 8: {
                    rect.height -= legendExt.y + 8;
                    gc.drawText(dci.getDescription(), rect.x + (rect.width - legendExt.x) / 2, rect.y + rect.height + 4, true);
                    break;
                }
                case 1: {
                    gc.drawText(dci.getDescription(), rect.x + 4, rect.y + (rect.height - legendExt.y) / 2, true);
                    rect.x += legendExt.x + 8;
                    rect.width -= legendExt.x + 8;
                    break;
                }
                case 2: {
                    rect.width -= legendExt.x + 8;
                    gc.drawText(dci.getDescription(), rect.x + rect.width + 4, rect.y + (rect.height - legendExt.y) / 2, true);
                }
            }
        }
        if (config.isTransposed()) {
            if (rect.height > 40) {
                int d = rect.height - 40;
                rect.height -= d;
                rect.y += d / 2;
            }
            rect.y -= 8;
        } else {
            if (rect.width > 40) {
                int d = rect.width - 40;
                rect.width -= d;
                rect.x += d / 2;
            }
            rect.x -= 10;
        }
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.PlotArea"));
        gc.setForeground(this.getColorFromPreferences("Chart.Colors.DialScale"));
        gc.fillRectangle(rect);
        gc.drawRectangle(rect);
        rect.x += 2;
        rect.y += 2;
        rect.width -= 3;
        rect.height -= 3;
        double maxValue = config.getMaxYScaleValue();
        double minValue = config.getMinYScaleValue();
        double d = pointValue = config.isTransposed() ? (maxValue - minValue) / (double)rect.width : (maxValue - minValue) / (double)rect.height;
        if (data.getCurrentValue() > minValue) {
            if (config.getGaugeColorMode() == GaugeColorMode.ZONE.getValue()) {
                double right = minValue;
                if (config.getLeftRedZone() > minValue) {
                    right = config.getLeftRedZone() + (config.getLeftYellowZone() - config.getLeftRedZone()) / 2.0;
                    this.drawZone(gc, rect, minValue, right, minValue, pointValue, RED_ZONE_COLOR, YELLOW_ZONE_COLOR, config.isTransposed());
                }
                double left = right;
                right = config.getLeftYellowZone() + (config.getRightYellowZone() - config.getLeftYellowZone()) / 2.0;
                this.drawZone(gc, rect, left, right, minValue, pointValue, config.getLeftYellowZone() > minValue ? YELLOW_ZONE_COLOR : GREEN_ZONE_COLOR, GREEN_ZONE_COLOR, config.isTransposed());
                left = right;
                right = config.getRightYellowZone() + (config.getRightRedZone() - config.getRightYellowZone()) / 2.0;
                if (config.getRightYellowZone() < config.getRightRedZone()) {
                    this.drawZone(gc, rect, left, right, minValue, pointValue, GREEN_ZONE_COLOR, YELLOW_ZONE_COLOR, config.isTransposed());
                    left = right;
                    this.drawZone(gc, rect, left, maxValue, minValue, pointValue, YELLOW_ZONE_COLOR, config.getRightRedZone() < maxValue ? RED_ZONE_COLOR : YELLOW_ZONE_COLOR, config.isTransposed());
                } else if (config.getRightRedZone() < maxValue) {
                    this.drawZone(gc, rect, left, right, minValue, pointValue, GREEN_ZONE_COLOR, RED_ZONE_COLOR, config.isTransposed());
                }
                double v = data.getCurrentValue();
                if (v < maxValue) {
                    gc.setBackground(this.getColorFromPreferences("Chart.Colors.PlotArea"));
                    if (config.isTransposed()) {
                        int points = (int)((v - minValue) / pointValue);
                        gc.fillRectangle(rect.x + points, rect.y, rect.width - points, rect.height);
                    } else {
                        int points = (int)((maxValue - v) / pointValue);
                        gc.fillRectangle(rect.x, rect.y, rect.width, points);
                    }
                }
            } else {
                if (config.getGaugeColorMode() == GaugeColorMode.THRESHOLD.getValue()) {
                    gc.setBackground(StatusDisplayInfo.getStatusColor((Severity)data.getActiveThresholdSeverity()));
                } else {
                    gc.setBackground(this.chart.getColorCache().create(this.chart.getPaletteEntry(0).getRGBObject()));
                }
                int points = (int)((data.getCurrentValue() - minValue) / pointValue);
                if (config.isTransposed()) {
                    if (points > rect.width) {
                        points = rect.width;
                    }
                    gc.fillRectangle(rect.x, rect.y, points, rect.height);
                } else {
                    if (points > rect.height) {
                        points = rect.height;
                    }
                    gc.fillRectangle(rect.x, rect.y + rect.height - points, rect.width, points);
                }
            }
        }
        this.drawScale(gc, rect, minValue, maxValue, pointValue, config.isTransposed(), config.isGridVisible());
    }

    private void drawZone(GC gc, Rectangle rect, double startValue, double endValue, double minValue, double pointValue, RGB startColor, RGB endColor, boolean isTransposed) {
        int start = (int)((startValue - minValue) / pointValue);
        int points = (int)((endValue - startValue) / pointValue) + 1;
        if (isTransposed) {
            gc.setForeground(this.chart.getColorCache().create(startColor));
            gc.setBackground(this.chart.getColorCache().create(endColor));
            gc.fillGradientRectangle(rect.x + start, rect.y, points, rect.height, false);
        } else {
            gc.setBackground(this.chart.getColorCache().create(startColor));
            gc.setForeground(this.chart.getColorCache().create(endColor));
            int y = rect.y + rect.height - start - points + 1;
            if (y + points >= rect.y + rect.height) {
                --points;
            }
            gc.fillGradientRectangle(rect.x, y, rect.width, points, true);
        }
    }

    private void drawScale(GC gc, Rectangle rect, double minValue, double maxValue, double pointValue, boolean isTransposed, boolean gridVisible) {
        Color scaleColor = this.getColorFromPreferences("Chart.Colors.DialScale");
        Color scaleTextColor = this.getColorFromPreferences("Chart.Colors.DialScaleText");
        Font markFont = WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.scaleFonts, (String)"900MM", (int)20, (int)16);
        gc.setFont(markFont);
        double step = BarGauge.getStepMagnitude(Math.max(Math.abs(minValue), Math.abs(maxValue)));
        double value = minValue;
        float pointsStep = (float)(step / pointValue);
        if (isTransposed) {
            float x = 0.0f;
            while (x < (float)rect.width) {
                if (gridVisible && x > 0.0f) {
                    gc.setForeground(scaleColor);
                    gc.drawLine(rect.x + (int)x, rect.y - 2, rect.x + (int)x, rect.y + rect.height + 1);
                }
                String text = DataFormatter.roundDecimalValue((double)value, (double)step, (int)5);
                gc.setForeground(scaleTextColor);
                gc.drawText(text, rect.x + (int)x, rect.y + rect.height + 4, 1);
                x += pointsStep;
                value += step;
            }
        } else {
            int textHeight = gc.textExtent((String)"999MM").y;
            float y = rect.height;
            while (y > 0.0f) {
                if (gridVisible && y < (float)rect.height) {
                    gc.setForeground(scaleColor);
                    gc.drawLine(rect.x - 2, rect.y + (int)y, rect.x + rect.width + 1, rect.y + (int)y);
                }
                String text = DataFormatter.roundDecimalValue((double)value, (double)step, (int)5);
                gc.setForeground(scaleTextColor);
                gc.drawText(text, rect.x + rect.width + 4, rect.y + (int)y - textHeight * 3 / 4, 1);
                y -= pointsStep;
                value += step;
            }
        }
    }

    private static double getStepMagnitude(double maxValue) {
        double d = 1.0E-5;
        while (d < 1.0E19) {
            if (maxValue > d && maxValue <= d * 10.0) break;
            d *= 10.0;
        }
        return d;
    }
}

