/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netxms.base.NXCPMessage;

public class NXCPMsgWaitQueue {
    private List<NXCPMessage> messageList = new ArrayList<NXCPMessage>(0);
    private int defaultTimeout;
    private int messageLifeTime;
    private boolean isActive = true;
    private HousekeeperThread housekeeperThread = null;

    public NXCPMsgWaitQueue(int defaultTimeout, int messageLifeTime) {
        this.defaultTimeout = defaultTimeout;
        this.messageLifeTime = messageLifeTime;
        this.housekeeperThread = new HousekeeperThread();
    }

    public NXCPMsgWaitQueue(int defaultTimeout) {
        this(defaultTimeout, 60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMessage(NXCPMessage msg) {
        List<NXCPMessage> list = this.messageList;
        synchronized (list) {
            msg.setTimestamp(System.currentTimeMillis());
            this.messageList.add(msg);
            this.messageList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NXCPMessage waitForMessage(int code, long id, int timeout) {
        NXCPMessage msg = null;
        int actualTimeout = timeout;
        while (actualTimeout > 0 && this.isActive) {
            List<NXCPMessage> list = this.messageList;
            synchronized (list) {
                Iterator<NXCPMessage> it = this.messageList.iterator();
                boolean found = false;
                while (it.hasNext()) {
                    msg = it.next();
                    if (msg.getMessageCode() != code || msg.getMessageId() != id) continue;
                    it.remove();
                    found = true;
                    break;
                }
                if (found) {
                    break;
                }
                msg = null;
                long startTime = System.currentTimeMillis();
                try {
                    this.messageList.wait(actualTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                actualTimeout = (int)((long)actualTimeout - (System.currentTimeMillis() - startTime));
            }
        }
        return msg;
    }

    public NXCPMessage waitForMessage(int code, long id) {
        return this.waitForMessage(code, id, this.defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        this.isActive = false;
        if (this.housekeeperThread != null) {
            this.housekeeperThread.interrupt();
            while (this.housekeeperThread.isAlive()) {
                try {
                    this.housekeeperThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.housekeeperThread = null;
        }
        List<NXCPMessage> list = this.messageList;
        synchronized (list) {
            this.messageList.notifyAll();
        }
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public String toString() {
        return "NXCPMsgWaitQueue [messageList=" + this.messageList.toString() + " defaultTimeout=" + this.defaultTimeout + " messageLifeTime=" + this.messageLifeTime + " isActive=" + this.isActive;
    }

    private class HousekeeperThread
    extends Thread {
        HousekeeperThread() {
            super("NXCPMsgWaitQueue::HousekeeperThread");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (NXCPMsgWaitQueue.this.isActive) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                List<NXCPMessage> list = NXCPMsgWaitQueue.this.messageList;
                synchronized (list) {
                    long currTime = System.currentTimeMillis();
                    Iterator<NXCPMessage> it = NXCPMsgWaitQueue.this.messageList.iterator();
                    while (it.hasNext()) {
                        NXCPMessage msg = it.next();
                        if (msg.getTimestamp() + (long)NXCPMsgWaitQueue.this.messageLifeTime >= currTime) continue;
                        it.remove();
                    }
                }
            }
        }
    }
}

