/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.eventmanager.dialogs.EventSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class EventSelector
extends AbstractSelector {
    private long eventCode = 0L;
    private String eventName = null;

    public EventSelector(Composite parent, int style) {
        this(parent, style, 0);
    }

    public EventSelector(Composite parent, int style, int options) {
        super(parent, style, options);
        Messages.get();
        this.setText(Messages.EventSelector_None);
    }

    protected void selectionButtonHandler() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            long prevEventCode = this.eventCode;
            EventTemplate[] events = dlg.getSelectedEvents();
            if (events.length > 0) {
                this.eventCode = events[0].getCode();
                this.eventName = events[0].getName();
                this.setText(events[0].getName());
                this.setImage(StatusDisplayInfo.getStatusImage((Severity)events[0].getSeverity()));
                this.getTextControl().setToolTipText(this.generateToolTipText(events[0]));
            } else {
                this.eventCode = 0L;
                this.eventName = null;
                Messages.get();
                this.setText(Messages.EventSelector_None);
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
            if (prevEventCode != this.eventCode) {
                this.fireModifyListeners();
            }
        }
    }

    protected void clearButtonHandler() {
        if (this.eventCode == 0L) {
            return;
        }
        this.eventCode = 0L;
        this.eventName = null;
        Messages.get();
        this.setText(Messages.EventSelector_None);
        this.setImage(null);
        this.getTextControl().setToolTipText(null);
        this.fireModifyListeners();
    }

    public long getEventCode() {
        return this.eventCode;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventCode(long eventCode) {
        if (this.eventCode == eventCode) {
            return;
        }
        this.eventCode = eventCode;
        if (eventCode != 0L) {
            EventTemplate evt = ConsoleSharedData.getSession().findEventTemplateByCode(eventCode);
            if (evt != null) {
                this.eventName = evt.getName();
                this.setText(this.eventName);
                this.setImage(StatusDisplayInfo.getStatusImage((Severity)evt.getSeverity()));
                this.getTextControl().setToolTipText(this.generateToolTipText(evt));
            } else {
                Messages.get();
                this.setText(Messages.EventSelector_Unknown);
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
        } else {
            Messages.get();
            this.setText(Messages.EventSelector_None);
            this.setImage(null);
            this.getTextControl().setToolTipText(null);
        }
        this.fireModifyListeners();
    }

    private String generateToolTipText(EventTemplate evt) {
        StringBuilder sb = new StringBuilder(evt.getName());
        sb.append(" [");
        sb.append(evt.getCode());
        Messages.get();
        sb.append(Messages.EventSelector_Severity);
        sb.append(StatusDisplayInfo.getStatusText((Severity)evt.getSeverity()));
        sb.append("\n\n");
        sb.append(evt.getMessage());
        sb.append("\n\n");
        sb.append(evt.getDescription().replace("\r", ""));
        return sb.toString();
    }

    protected String getSelectionButtonToolTip() {
        Messages.get();
        return Messages.EventSelector_Tooltip;
    }
}

