/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.objecttabs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.TableRow;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.agentmanager.Activator;
import org.netxms.ui.eclipse.agentmanager.Messages;
import org.netxms.ui.eclipse.agentmanager.objecttabs.helpers.AgentSessionFilter;
import org.netxms.ui.eclipse.agentmanager.objecttabs.helpers.UserSessionComparator;
import org.netxms.ui.eclipse.agentmanager.objecttabs.helpers.UserSessionLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.ViewRefreshController;
import org.netxms.ui.eclipse.tools.VisibilityValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class UserSessionsTab
extends ObjectTab {
    public static final String[] COLUMNS = new String[]{"SESSION_ID", "SESSION_NAME", "USER_NAME", "CLIENT_NAME", "STATE", "AGENT_TYPE"};
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_SESSION = 1;
    public static final int COLUMN_USER = 2;
    public static final int COLUMN_CLIENT = 3;
    public static final int COLUMN_STATE = 4;
    public static final int COLUMN_AGENT_TYPE = 5;
    private NXCSession session;
    private AbstractObject object;
    private org.netxms.client.Table sessionsTable = null;
    private boolean showFilter = true;
    private CompositeWithMessageBar viewerContainer;
    private SortableTableViewer viewer;
    private FilterText filterText;
    private AgentSessionFilter filter;
    private ViewRefreshController refreshController;
    private Action actionExportToCsv;
    private Action actionTakeScreenshot;

    protected void createTabContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.session = ConsoleSharedData.getSession();
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.showFilter = UserSessionsTab.getBooleanFromSettings(settings, "UserSessionsTab.showFilter", this.showFilter);
        this.viewerContainer = new CompositeWithMessageBar(parent, 0){

            protected Composite createContent(Composite parent) {
                Composite content = super.createContent(parent);
                content.setLayout((Layout)new FormLayout());
                return content;
            }
        };
        this.filterText = new FilterText(this.viewerContainer.getContent(), 0, null, true);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserSessionsTab.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                UserSessionsTab.this.enableFilter(false);
            }
        });
        String[] names = new String[]{"Session id", "Session", "User", "Client", "State", "Agent type"};
        int[] widths = new int[]{150, 150, 100, 150, 150, 100};
        this.viewer = new SortableTableViewer(this.viewerContainer.getContent(), names, widths, 0, 128, 65538);
        this.viewer.setLabelProvider((IBaseLabelProvider)new UserSessionLabelProvider(this));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new UserSessionComparator(this));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.filter = new AgentSessionFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"UserSessions");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)UserSessionsTab.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"UserSessions");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        VisibilityValidator validator = new VisibilityValidator(){

            public boolean isVisible() {
                return UserSessionsTab.this.isActive();
            }
        };
        this.refreshController = new ViewRefreshController((IViewPart)this.getViewPart(), -1, new Runnable(){

            @Override
            public void run() {
                if (UserSessionsTab.this.viewer.getTable().isDisposed()) {
                    return;
                }
                UserSessionsTab.this.refresh();
            }
        }, validator);
        this.refreshController.setInterval(30);
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.put("UserSessionsTab.showFilter", UserSessionsTab.this.showFilter);
                UserSessionsTab.this.refreshController.dispose();
            }
        });
        if (this.showFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.createActions();
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager(String.valueOf(this.getViewPart().getSite().getId()) + ".UserSessionsTab");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UserSessionsTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
        this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() >= 1) {
            manager.add((IAction)this.actionExportToCsv);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionTakeScreenshot);
        }
    }

    private void createActions() {
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this.getViewPart(), (ColumnViewer)this.viewer, true);
        this.actionTakeScreenshot = new Action("Take screenshot"){

            public void run() {
                UserSessionsTab.this.takeScreenshot();
            }
        };
    }

    private void takeScreenshot() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() >= 1) {
            int colIndexName = this.sessionsTable.getColumnIndex("SESSION_NAME");
            int colIndexUser = this.sessionsTable.getColumnIndex("USER_NAME");
            for (Object o : selection.toList()) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.agentmanager.views.ScreenshotView", String.valueOf(Long.toString(this.object.getObjectId())) + "&" + ((TableRow)o).get(colIndexName).getValue() + "&" + ((TableRow)o).get(colIndexUser).getValue(), 1);
                }
                catch (PartInitException e) {
                    Shell shell = this.getViewPart().getViewSite().getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.TakeScreenshot_Error, (String)String.format(Messages.TakeScreenshot_ErrorOpeningView, e.getLocalizedMessage()));
                }
            }
        }
    }

    public void enableFilter(boolean enable) {
        this.showFilter = enable;
        this.filterText.setVisible(this.showFilter);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.viewerContainer.layout(true, true);
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    private void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private static boolean getBooleanFromSettings(IDialogSettings settings, String name, boolean defaultValue) {
        if (settings.get(name) == null) {
            return defaultValue;
        }
        return settings.getBoolean(name);
    }

    public void objectChanged(AbstractObject object) {
        this.object = object;
        if (this.getViewPart().getSite().getPage().isPartVisible((IWorkbenchPart)this.getViewPart()) && this.isActive()) {
            this.refresh();
        }
    }

    public boolean showForObject(AbstractObject object) {
        return object instanceof Node && ((Node)object).hasAgent();
    }

    public void refresh() {
        if (!this.isActive()) {
            return;
        }
        ConsoleJob job = new ConsoleJob("Get list of agent sessions", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.agentmanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    UserSessionsTab.this.sessionsTable = UserSessionsTab.this.session.queryAgentTable(UserSessionsTab.this.object.getObjectId(), "Agent.SessionAgents");
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).UserSessionsTab.this.viewer.getControl().isDisposed()) {
                                return;
                            }
                            (this).UserSessionsTab.this.viewer.setInput((Object)(this).UserSessionsTab.this.sessionsTable.getAllRows());
                            (this).UserSessionsTab.this.viewerContainer.hideMessage();
                        }
                    });
                }
                catch (Exception e) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).UserSessionsTab.this.viewer.setInput((Object)new Object[0]);
                            (this).UserSessionsTab.this.viewerContainer.showMessage(2, String.format("Cannot get user sessions (%s)", e.getLocalizedMessage()));
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot get list of user agent sessions";
            }
        };
        job.setUser(false);
        job.start();
    }

    public void selected() {
        super.selected();
        this.refresh();
    }

    public org.netxms.client.Table getTable() {
        return this.sessionsTable;
    }
}

