/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.widgets;

import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.netxms.client.AgentFileData;
import org.netxms.client.NXCSession;
import org.netxms.client.ProgressListener;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.server.ServerJobIdUpdater;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.widgets.BaseFileViewer;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.jobs.ConsoleJobCallingServerJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFileViewer
extends BaseFileViewer {
    private static Logger logger = LoggerFactory.getLogger(DynamicFileViewer.class);
    protected ConsoleJob monitoringJob = null;
    protected ConsoleJob restartJob = null;
    protected long nodeId = 0L;
    protected String remoteFileName;
    protected NXCSession session = ConsoleSharedData.getSession();

    public DynamicFileViewer(Composite parent, int style, IViewPart viewPart) {
        super(parent, style, viewPart);
        final SessionListener sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1026 && n.getSubCode() == DynamicFileViewer.this.nodeId) {
                    DynamicFileViewer.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DynamicFileViewer.this.restartTracking();
                        }
                    });
                }
            }
        };
        this.session.addListener(sessionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DynamicFileViewer.this.session.removeListener(sessionListener);
                DynamicFileViewer.this.stopTracking();
            }
        });
    }

    public void startTracking(UUID monitorId, long nodeId, String remoteFileName) {
        if (this.restartJob != null) {
            this.restartJob.cancel();
            this.restartJob = null;
        }
        if (this.monitoringJob != null) {
            this.monitoringJob.cancel();
            this.monitoringJob = null;
        }
        this.hideMessage();
        this.nodeId = nodeId;
        this.remoteFileName = remoteFileName;
        this.text.setTopIndex(this.text.getLineCount() - 1);
        if (monitorId != null) {
            this.monitoringJob = new MonitoringJob(monitorId);
            this.monitoringJob.start();
        } else {
            this.restartTracking();
        }
    }

    public void stopTracking() {
        if (this.restartJob != null) {
            this.restartJob.cancel();
            this.restartJob = null;
        }
        if (this.monitoringJob != null) {
            this.monitoringJob.cancel();
            this.monitoringJob = null;
            this.nodeId = 0L;
        }
    }

    private void restartTracking() {
        if (this.monitoringJob != null) {
            this.monitoringJob.cancel();
            this.monitoringJob = null;
        }
        if (this.restartJob != null) {
            this.restartJob.cancel();
        }
        StringBuilder stringBuilder = new StringBuilder("\n\n----------------------------------------------------------------------\n");
        Messages.get();
        this.text.append(stringBuilder.append(Messages.FileViewer_NotifyFollowConnectionLost).append("\n----------------------------------------------------------------------\n").toString());
        Messages.get();
        this.showMessage(2, Messages.FileViewer_NotifyFollowConnectionLost);
        Messages.get();
        this.restartJob = new ConsoleJobCallingServerJob(Messages.DynamicFileViewer_RestartFileTracking, null, "org.netxms.ui.eclipse.filemanager"){
            private boolean running;
            {
                this.running = true;
            }

            protected void canceling() {
                this.running = false;
            }

            protected void runInternal(final IProgressMonitor monitor) throws Exception {
                while (this.running) {
                    try {
                        final AgentFileData file = DynamicFileViewer.this.session.downloadFileFromAgent(DynamicFileViewer.this.nodeId, DynamicFileViewer.this.remoteFileName, 1024L, true, new ProgressListener(){

                            public void setTotalWorkAmount(long workTotal) {
                                monitor.beginTask("Track file " + (this).DynamicFileViewer.this.remoteFileName, (int)workTotal);
                            }

                            public void markProgress(long workDone) {
                                monitor.worked((int)workDone);
                            }
                        }, (ServerJobIdUpdater)this);
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).DynamicFileViewer.this.text.isDisposed()) {
                                    running = false;
                                    return;
                                }
                                DynamicFileViewer.this.hideMessage();
                                StyledText styledText = (this).DynamicFileViewer.this.text;
                                StringBuilder stringBuilder = new StringBuilder("-------------------------------------------------------------------------------\n");
                                Messages.get();
                                styledText.append(stringBuilder.append(Messages.FileViewer_NotifyFollowConnectionEnabed).append("\n-------------------------------------------------------------------------------\n\n").toString());
                                DynamicFileViewer.this.append(DynamicFileViewer.loadFile(file.getFile()));
                                DynamicFileViewer.this.startTracking(file.getMonitorId(), (this).DynamicFileViewer.this.nodeId, (this).DynamicFileViewer.this.remoteFileName);
                            }
                        });
                        break;
                    }
                    catch (Exception exception) {
                        Thread.sleep(20000L);
                    }
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DynamicFileViewer_CannotRestartFileTracking;
            }
        };
        this.restartJob.setUser(false);
        this.restartJob.setSystem(true);
        this.restartJob.start();
    }

    private class MonitoringJob
    extends ConsoleJob {
        private boolean tracking;
        private UUID monitorId;

        public MonitoringJob(UUID monitorId) {
            Messages.get();
            super(Messages.DynamicFileViewer_TrackFileChanges, null, "org.netxms.ui.eclipse.filemanager");
            this.tracking = true;
            this.monitorId = monitorId;
            this.setUser(false);
            this.setSystem(true);
        }

        protected void canceling() {
            this.tracking = false;
        }

        protected void runInternal(IProgressMonitor monitor) throws Exception {
            while (this.tracking) {
                final String s = DynamicFileViewer.this.session.waitForFileUpdate(this.monitorId, 3000);
                if (s == null) continue;
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!((MonitoringJob)MonitoringJob.this).DynamicFileViewer.this.text.isDisposed()) {
                            DynamicFileViewer.this.append(s);
                        } else {
                            MonitoringJob.this.tracking = false;
                        }
                    }
                });
            }
            try {
                DynamicFileViewer.this.session.cancelFileMonitoring(this.monitorId);
            }
            catch (Exception e) {
                logger.warn(String.format("Cannot cancel file monitor with ID %s for node %s", this.monitorId.toString(), DynamicFileViewer.this.session.getObjectName(DynamicFileViewer.this.nodeId)), (Throwable)e);
            }
        }

        protected String getErrorMessage() {
            Messages.get();
            return Messages.DynamicFileViewer_FileTrackingFailed;
        }
    }
}

