/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.snmp.SnmpVersion;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.TableElement;

public class Capabilities
extends TableElement {
    public Capabilities(Composite parent, OverviewPageElement anchor, ObjectTab objectTab) {
        super(parent, anchor, objectTab);
    }

    @Override
    protected String getTitle() {
        Messages.get();
        return Messages.Capabilities_Title;
    }

    @Override
    protected void fillTable() {
        if (!(this.getObject() instanceof AbstractNode)) {
            return;
        }
        AbstractNode node = (AbstractNode)this.getObject();
        this.addFlag("802.1x", (node.getCapabilities() & 0x2000) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsAgent, (node.getCapabilities() & 2) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsBridge, (node.getCapabilities() & 4) != 0);
        this.addFlag("CDP", (node.getCapabilities() & 0x100) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagHasEntityMIB, (node.getCapabilities() & 0x8000) != 0);
        this.addFlag("EtherNet/IP", (node.getCapabilities() & 0x800000) != 0);
        this.addFlag("LLDP", (node.getCapabilities() & 0x400) != 0);
        this.addFlag("NDP", (node.getCapabilities() & 0x200) != 0);
        this.addFlag("OSPF", (node.getCapabilities() & 0x40) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsPrinter, (node.getCapabilities() & 0x20) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsRouter, (node.getCapabilities() & 8) != 0);
        this.addFlag("SMCLP", (node.getCapabilities() & 0x100000) != 0);
        this.addFlag("SNMP", (node.getCapabilities() & 1) != 0);
        if ((node.getCapabilities() & 1) != 0) {
            Messages.get();
            this.addFlag(Messages.Capabilities_FlagHasIfXTable, (node.getCapabilities() & 0x10000) != 0);
            Messages.get();
            this.addPair(Messages.Capabilities_SNMPPort, Integer.toString(node.getSnmpPort()));
            Messages.get();
            this.addPair(Messages.Capabilities_SNMPVersion, this.getSnmpVersionName(node.getSnmpVersion()));
        }
        this.addFlag("SSH", (node.getCapabilities() & 0x80) != 0);
        this.addFlag("STP", (node.getCapabilities() & 0x4000) != 0);
        this.addFlag("User Agent", (node.getCapabilities() & 0x400000) != 0);
        this.addFlag("VRRP", (node.getCapabilities() & 0x800) != 0);
    }

    private void addFlag(String name, boolean value) {
        String string;
        if (value) {
            Messages.get();
            string = Messages.Capabilities_Yes;
        } else {
            Messages.get();
            string = Messages.Capabilities_No;
        }
        this.addPair(name, string);
    }

    private String getSnmpVersionName(SnmpVersion version) {
        switch (version) {
            case V1: {
                return "1";
            }
            case V2C: {
                return "2c";
            }
            case V3: {
                return "3";
            }
        }
        return "???";
    }

    @Override
    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof AbstractNode;
    }
}

