/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netxms.client.packages.PackageDeploymentListener;
import org.netxms.nxmc.modules.agentmanagement.views.PackageDeploymentMonitor;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.DeploymentStatus;

public class PackageDeployment
implements PackageDeploymentListener {
    private Set<PackageDeploymentMonitor> monitors;
    private Map<Long, DeploymentStatus> statusList = new HashMap();

    public PackageDeployment(PackageDeploymentMonitor monitor) {
        this.monitors = new HashSet();
        this.monitors.add(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statusUpdate(long nodeId, int status, String message) {
        Set set = this.monitors;
        synchronized (set) {
            DeploymentStatus s = (DeploymentStatus)this.statusList.get(nodeId);
            if (s == null) {
                s = new DeploymentStatus(nodeId, status, message);
                this.statusList.put(nodeId, s);
            } else {
                s.setStatus(status);
                s.setMessage(message);
            }
            for (PackageDeploymentMonitor monitor : this.monitors) {
                monitor.viewStatusUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(PackageDeploymentMonitor monitor) {
        Set set = this.monitors;
        synchronized (set) {
            this.monitors.add(monitor);
            monitor.viewStatusUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitor(PackageDeploymentMonitor monitor) {
        Set set = this.monitors;
        synchronized (set) {
            this.monitors.remove(monitor);
        }
    }

    public void deploymentStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploymentComplete() {
        Set set = this.monitors;
        synchronized (set) {
            for (PackageDeploymentMonitor monitor : this.monitors) {
                monitor.deploymentComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DeploymentStatus> getDeployments() {
        Collection<DeploymentStatus> deployments;
        Set set = this.monitors;
        synchronized (set) {
            deployments = this.statusList.values();
        }
        return deployments;
    }
}

