/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.ObjectIdMatchingData;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Persister;

public class EmbeddedDashboardConfig
extends DashboardElementConfig {
    @Element(required=false)
    private long objectId = 0L;
    @Element(required=false)
    private long[] dashboardObjects = new long[0];
    @Element(required=false)
    private int displayInterval = 60;

    public static EmbeddedDashboardConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        EmbeddedDashboardConfig config = (EmbeddedDashboardConfig)serializer.read(EmbeddedDashboardConfig.class, xml);
        if (config.objectId != 0L && config.dashboardObjects.length == 0) {
            config.dashboardObjects = new long[1];
            config.dashboardObjects[0] = config.objectId;
            config.objectId = 0L;
        }
        return config;
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public Set<Long> getObjects() {
        Set objects = super.getObjects();
        objects.add(this.objectId);
        for (long id : this.dashboardObjects) {
            objects.add(id);
        }
        return objects;
    }

    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
        for (int i = 0; i < this.dashboardObjects.length; ++i) {
            md = remapData.get(this.dashboardObjects[i]);
            if (md == null) continue;
            this.dashboardObjects[i] = md.dstId;
        }
    }

    public long[] getDashboardObjects() {
        return this.dashboardObjects;
    }

    public void setDashboardObjects(long[] dashboardObjects) {
        this.dashboardObjects = dashboardObjects;
    }

    public int getDisplayInterval() {
        return this.displayInterval;
    }

    public void setDisplayInterval(int displayInterval) {
        this.displayInterval = displayInterval;
    }
}

