/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.widgets.DashboardComposite;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.base.widgets.MessageArea;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementLayout;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.EditPaneWidget;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.FontTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementWidget
extends DashboardComposite
implements ControlListener,
MessageAreaHolder {
    private static final Logger logger = LoggerFactory.getLogger(ElementWidget.class);
    protected DashboardElement element;
    protected AbstractDashboardView view;
    private Label title;
    private Composite mainArea;
    private Composite content;
    private Font titleFont;
    private DashboardControl dbc;
    private DashboardElementLayout layout;
    private boolean editMode = false;
    private EditPaneWidget editPane = null;
    private MessageArea messageArea;
    private FilterText filterText = null;
    private boolean hasFilter = false;

    protected ElementWidget(DashboardControl parent, int style, DashboardElement element, AbstractDashboardView view) {
        super((Composite)parent, style);
        this.dbc = parent;
        this.element = element;
        this.view = view;
        this.setupElement();
    }

    protected ElementWidget(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super((Composite)parent, 2048);
        this.dbc = parent;
        this.element = element;
        this.view = view;
        this.setupElement();
    }

    protected ElementWidget(DashboardControl parent, DashboardElement element, AbstractDashboardView view, boolean hasFilter) {
        super((Composite)parent, 2048);
        this.dbc = parent;
        this.element = element;
        this.view = view;
        this.hasFilter = hasFilter;
        this.setupElement();
    }

    private void setupElement() {
        this.parseLayout(this.element.getLayout());
        this.addControlListener((ControlListener)this);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 4;
        this.setLayout((Layout)layout);
        this.mainArea = new Composite((Composite)this, 0);
        this.mainArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainArea.setLayout((Layout)new FormLayout());
        this.mainArea.setBackground(this.getBackground());
        this.messageArea = new MessageArea(this.mainArea, 0);
        if (this.hasFilter) {
            this.filterText = new FilterText(this.mainArea, 0, null, false, false);
            this.filterText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.content = new /* Unavailable Anonymous Inner Class!! */;
        this.content.setLayout((Layout)new FillLayout());
        this.content.setBackground(this.getBackground());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.messageArea.setLayoutData((Object)fd);
        if (this.hasFilter) {
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment((Control)this.messageArea);
            fd.right = new FormAttachment(100, 0);
            this.filterText.setLayoutData((Object)fd);
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment((Control)this.filterText);
            fd.right = new FormAttachment(100, 0);
            fd.bottom = new FormAttachment(100, 0);
            this.content.setLayoutData((Object)fd);
        } else {
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment((Control)this.messageArea);
            fd.right = new FormAttachment(100, 0);
            fd.bottom = new FormAttachment(100, 0);
            this.content.setLayoutData((Object)fd);
        }
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onFilterModify() {
    }

    protected Composite getContentArea() {
        return this.content;
    }

    protected int adjustContentHeight(Composite content, Point computedSize) {
        return -1;
    }

    protected void setTitle(String text, RGB backgroundColor, RGB foregroundColor, int textSizeAdjustment) {
        if (this.title != null) {
            this.title.dispose();
        }
        this.title = new Label((Composite)this, 0x1000000);
        this.title.setText(text.replace("&", "&&"));
        if (backgroundColor != null) {
            this.title.setBackground(this.colors.create(backgroundColor));
            this.setBackground(this.title.getBackground());
        } else {
            this.title.setBackground(this.getBackground());
        }
        if (foregroundColor != null) {
            this.title.setForeground(this.colors.create(foregroundColor));
        }
        if (this.titleFont != null) {
            this.titleFont.dispose();
        }
        this.titleFont = FontTools.createAdjustedFont((Font)JFaceResources.getBannerFont(), (int)textSizeAdjustment);
        this.title.setFont(this.titleFont);
        GridData gd = new GridData(0x1000000, 0x1000000, true, false);
        gd.verticalIndent = 4;
        this.title.setLayoutData((Object)gd);
        this.title.moveAbove(null);
        this.layout(true, true);
    }

    protected void processCommonSettings(DashboardElementConfig config) {
        if (!config.getTitle().isEmpty()) {
            this.setTitle(config.getTitle(), ColorConverter.parseColorDefinition((String)config.getTitleBackground()), ColorConverter.parseColorDefinition((String)config.getTitleForeground()), config.getTitleFontSize());
        }
    }

    private void parseLayout(String xml) {
        try {
            this.layout = DashboardElementLayout.createFromXml((String)xml);
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element layout", (Throwable)e);
            this.layout = new DashboardElementLayout();
        }
    }

    public DashboardElementLayout getElementLayout() {
        return this.layout;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
        if (editMode) {
            this.editPane = new EditPaneWidget((Composite)this, this.dbc, this.element);
            this.editPane.setLocation(0, 0);
            this.editPane.setSize(this.getSize());
            this.editPane.moveAbove(null);
        } else if (this.editPane != null) {
            this.editPane.dispose();
            this.editPane = null;
        }
    }

    protected void enableFilter(boolean enable) {
        if (!this.hasFilter) {
            return;
        }
        this.filterText.setVisible(enable);
        FormData fd = (FormData)this.content.getLayoutData();
        fd.top = new FormAttachment((Control)(enable ? this.filterText : this.messageArea));
        this.mainArea.layout(true, true);
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    protected String getFilterText() {
        return this.hasFilter ? this.filterText.getText() : "";
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.editPane != null) {
            this.editPane.setLocation(0, 0);
            this.editPane.setSize(this.getSize());
            this.editPane.moveAbove(null);
        }
    }

    protected void requestDashboardLayout() {
        this.dbc.layout(true, true);
    }

    protected long getDashboardObjectId() {
        return this.dbc.getDashboardObject().getObjectId();
    }

    protected AbstractObject getContext() {
        return this.dbc.getContext();
    }

    protected long getContextObjectId() {
        AbstractObject object = this.dbc.getContext();
        return object != null ? object.getObjectId() : 0L;
    }

    protected long getEffectiveObjectId(long objectId) {
        return objectId == 0xFFFFFFFFL ? this.getContextObjectId() : objectId;
    }

    public int addMessage(int level, String text) {
        return this.messageArea.addMessage(level, text);
    }

    public int addMessage(int level, String text, boolean sticky) {
        return this.messageArea.addMessage(level, text, sticky);
    }

    public void deleteMessage(int id) {
        this.messageArea.deleteMessage(id);
    }

    public void clearMessages() {
        this.messageArea.clearMessages();
    }
}

