/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.datacollection.views.DataComparisonView;
import org.netxms.nxmc.modules.datacollection.views.HistoricalDataView;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.modules.datacollection.views.TableLastValuesView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.xnap.commons.i18n.I18n;

public class ShowHistoricalDataMenuItems {
    private static final I18n i18n = LocalizationHelper.getI18n(ShowHistoricalDataMenuItems.class);
    private View view;
    private StructuredViewer viewer;
    private AbstractObject parent;
    private Action actionShowHistory;
    private Action actionRawLineChart;
    private Action actionShowLineChart;
    private Action actionShowBarChart;
    private Action actionShowPieChart;
    private Action actionShowTableData;

    public static void populateMenu(IMenuManager manager, View view, AbstractObject object, StructuredViewer viewer, int selectionType) {
        ShowHistoricalDataMenuItems items = new ShowHistoricalDataMenuItems(view, object, viewer);
        if (selectionType == 1) {
            manager.add((IAction)items.actionShowHistory);
            manager.add((IAction)items.actionRawLineChart);
            manager.add((IAction)items.actionShowLineChart);
            manager.add((IAction)items.actionShowBarChart);
            manager.add((IAction)items.actionShowPieChart);
            manager.add((IContributionItem)new Separator());
        }
        if (selectionType == 2) {
            manager.add((IAction)items.actionShowTableData);
            manager.add((IContributionItem)new Separator());
        }
    }

    private ShowHistoricalDataMenuItems(View view, AbstractObject parent, StructuredViewer viewer) {
        this.view = view;
        this.viewer = viewer;
        this.parent = parent;
        this.createActions();
    }

    protected void createActions() {
        this.actionShowHistory = new /* Unavailable Anonymous Inner Class!! */;
        this.view.addKeyBinding("M1+H", (IAction)this.actionShowHistory);
        this.actionShowLineChart = new /* Unavailable Anonymous Inner Class!! */;
        this.view.addKeyBinding("M1+L", (IAction)this.actionShowLineChart);
        this.actionShowBarChart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowPieChart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRawLineChart = new /* Unavailable Anonymous Inner Class!! */;
        this.view.addKeyBinding("M1+M2+L", (IAction)this.actionRawLineChart);
        this.actionShowTableData = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected long getDciId(Object dci) {
        return dci instanceof DataCollectionObject ? ((DataCollectionObject)dci).getId() : ((DciValue)dci).getId();
    }

    protected long getObjectId(Object dci) {
        return dci instanceof DataCollectionObject ? ((DataCollectionObject)dci).getNodeId() : ((DciValue)dci).getNodeId();
    }

    private void showHistoryData() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        for (Object dcObject : selection.toList()) {
            if (dcObject instanceof DataCollectionTable || dcObject instanceof DciValue && ((DciValue)dcObject).getDcObjectType() == 2) {
                this.view.openView((View)new TableLastValuesView(this.parent, this.getObjectId(dcObject), this.getDciId(dcObject)));
                continue;
            }
            this.view.openView((View)new HistoricalDataView(this.parent, this.getObjectId(dcObject), this.getDciId(dcObject), null, null, null));
        }
    }

    protected ChartDciConfig getConfigFromObject(Object o) {
        return new ChartDciConfig((DciValue)o);
    }

    private void showLineChart(boolean useRawValues) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<ChartDciConfig> items = new ArrayList<ChartDciConfig>(selection.size());
        for (Object o : selection.toList()) {
            ChartDciConfig config = this.getConfigFromObject(o);
            config.useRawValues = useRawValues;
            items.add(config);
        }
        long contextId = this.view instanceof ObjectView ? ((ObjectView)this.view).getObjectId() : 0L;
        this.view.openView((View)new HistoricalGraphView(this.parent, items, contextId));
    }

    private void showDataComparisonChart(ChartType chartType) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<GraphItem> items = new ArrayList<GraphItem>(selection.size());
        for (Object o : selection.toList()) {
            items.add(new GraphItem((DciValue)o, null));
        }
        long contextId = this.view instanceof ObjectView ? ((ObjectView)this.view).getObjectId() : 0L;
        this.view.openView((View)new DataComparisonView(this.parent.getObjectId(), items, chartType, contextId));
    }
}

