/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.TableThreshold;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class TableThresholdLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = Registry.getSession();
    private Image thresholdIcon = ResourceManager.getImageDescriptor((String)"icons/threshold.png").createImage();

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.thresholdIcon;
            }
            case 2: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((TableThreshold)element).getActivationEvent());
                return StatusDisplayInfo.getStatusImage((Severity)(event != null ? event.getSeverity() : Severity.UNKNOWN));
            }
            case 3: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((TableThreshold)element).getDeactivationEvent());
                return StatusDisplayInfo.getStatusImage((Severity)(event != null ? event.getSeverity() : Severity.UNKNOWN));
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((TableThreshold)element).getConditionAsText();
            }
            case 1: {
                return Integer.toString(((TableThreshold)element).getSampleCount());
            }
            case 2: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((TableThreshold)element).getActivationEvent());
                return event.getName();
            }
            case 3: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((TableThreshold)element).getDeactivationEvent());
                return event.getName();
            }
        }
        return null;
    }

    public void dispose() {
        this.thresholdIcon.dispose();
        super.dispose();
    }
}

