/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.imagelibrary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.LibraryImage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.imagelibrary.ImageProviderTools;
import org.netxms.nxmc.modules.imagelibrary.ImageUpdateListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ImageProvider {
    private static final Logger logger = LoggerFactory.getLogger(ImageProvider.class);
    private final I18n i18n = LocalizationHelper.getI18n(ImageProvider.class);
    private final NXCSession session;
    private final Display display;
    private final Image missingImage;
    private final Map<UUID, Image> imageCache = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Image> objectIconCache = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, LibraryImage> libraryIndex = Collections.synchronizedMap(new HashMap());
    private final Set<ImageUpdateListener> updateListeners = new HashSet();

    public static void createInstance(Display display, NXCSession session) {
        Registry.setSingleton((Display)display, ImageProvider.class, (Object)new ImageProvider(display, session));
    }

    public static ImageProvider getInstance() {
        return (ImageProvider)Registry.getSingleton(ImageProvider.class);
    }

    private ImageProvider(Display display, NXCSession session) {
        this.display = display;
        this.session = session;
        this.missingImage = ResourceManager.getImage((String)"icons/missing.png");
    }

    public void addUpdateListener(ImageUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(ImageUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    private void notifyListeners(UUID guid) {
        for (ImageUpdateListener listener : this.updateListeners) {
            listener.imageUpdated(guid);
        }
    }

    public void syncMetaData() throws IOException, NXCException {
        List imageLibrary = this.session.getImageLibrary();
        this.libraryIndex.clear();
        this.clearCache();
        for (LibraryImage libraryImage : imageLibrary) {
            this.libraryIndex.put(libraryImage.getGuid(), libraryImage);
        }
    }

    private void clearCache() {
        for (Image image : this.imageCache.values()) {
            if (image == this.missingImage) continue;
            image.dispose();
        }
        this.imageCache.clear();
        for (Image image : this.objectIconCache.values()) {
            if (image == this.missingImage || image.isDisposed()) continue;
            image.dispose();
        }
        this.objectIconCache.clear();
    }

    public Image getImage(UUID guid) {
        Image image;
        if (guid == null) {
            return this.missingImage;
        }
        if (this.imageCache.containsKey(guid)) {
            image = (Image)this.imageCache.get(guid);
        } else {
            image = this.missingImage;
            this.loadImageFromServer(guid);
        }
        return image;
    }

    public Image getObjectIcon(UUID guid) {
        Image image;
        if (guid == null) {
            return this.missingImage;
        }
        if (this.objectIconCache.containsKey(guid)) {
            image = (Image)this.objectIconCache.get(guid);
        } else if (this.imageCache.containsKey(guid)) {
            image = ImageProviderTools.createResizedImage((Image)((Image)this.imageCache.get(guid)), (int)16);
            this.objectIconCache.put(guid, image);
        } else {
            image = this.missingImage;
            this.loadImageFromServer(guid);
        }
        return image;
    }

    private void loadImageFromServer(UUID guid) {
        this.imageCache.put(guid, this.missingImage);
        if (!this.libraryIndex.containsKey(guid)) {
            return;
        }
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public LibraryImage getLibraryImageObject(UUID guid) {
        return (LibraryImage)this.libraryIndex.get(guid);
    }

    public List<LibraryImage> getImageLibrary() {
        return new ArrayList<LibraryImage>(this.libraryIndex.values());
    }

    public void updateImage(UUID guid) {
        Image image = (Image)this.imageCache.remove(guid);
        if (image != null && image != this.missingImage) {
            image.dispose();
        }
        if ((image = (Image)this.objectIconCache.remove(guid)) != null && image != this.missingImage && !image.isDisposed()) {
            image.dispose();
        }
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    public void deleteImage(UUID guid) {
        Image image = (Image)this.imageCache.remove(guid);
        if (image != null && image != this.missingImage) {
            image.dispose();
        }
        if ((image = (Image)this.objectIconCache.remove(guid)) != null && image != this.missingImage && !image.isDisposed()) {
            image.dispose();
        }
        this.libraryIndex.remove(guid);
        this.display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }
}

