/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.actions.ViewerProvider;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.SoftwareInventoryView;
import org.netxms.nxmc.modules.objects.widgets.SoftwareInventory;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class SoftwareInventoryView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(SoftwareInventory.class);
    public static final String ID = "org.netxms.ui.eclipse.objectview.views.SoftwareInventoryView";
    private SoftwareInventory inventoryWidget;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public SoftwareInventoryView() {
        super(i18n.tr("Software Inventory"), ResourceManager.getImageDescriptor((String)"icons/object-views/software.png"), "SoftwareInventory", false);
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.refresh();
    }

    protected void createContent(Composite parent) {
        this.inventoryWidget = new SoftwareInventory(parent, 0, (ObjectView)this, "SoftwareInventoryView");
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        1 vp = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ViewerProvider)vp, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ViewerProvider)vp, false);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.inventoryWidget.setViewerMenu(menuMgr);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
    }

    public void refresh() {
        this.inventoryWidget.refresh();
    }

    protected void onObjectChange(AbstractObject object) {
        this.inventoryWidget.clear();
        if (object == null) {
            return;
        }
        this.inventoryWidget.setRootObjectId(object.getObjectId());
        this.inventoryWidget.refresh();
    }

    public boolean isValidForContext(Object context) {
        if (context != null && context instanceof Node) {
            return (((Node)context).getCapabilities() & 2) != 0;
        }
        return context != null && context instanceof Container;
    }

    public int getPriority() {
        return 60;
    }
}

