/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.api;

import java.util.Arrays;
import java.util.Date;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;

public class DataSeries {
    private DataType dataType;
    private DciDataRow[] values;
    private Severity currentThresholdSeverity;

    public DataSeries() {
        this.dataType = DataType.FLOAT;
        this.values = new DciDataRow[0];
        this.currentThresholdSeverity = Severity.NORMAL;
    }

    public DataSeries(DciData data) {
        this.dataType = data.getDataType();
        this.values = data.getValues();
        this.currentThresholdSeverity = Severity.NORMAL;
    }

    public DataSeries(DciDataRow value) {
        this(value, DataType.FLOAT, Severity.NORMAL);
    }

    public DataSeries(DciDataRow value, DataType dataType) {
        this(value, dataType, Severity.NORMAL);
    }

    public DataSeries(DciDataRow value, DataType dataType, Severity currentThresholdSeverity) {
        this.dataType = dataType;
        this.values = new DciDataRow[1];
        this.values[0] = value;
        this.currentThresholdSeverity = currentThresholdSeverity;
    }

    public DataSeries(double value) {
        this.dataType = DataType.FLOAT;
        this.values = new DciDataRow[1];
        this.values[0] = new DciDataRow(new Date(), (Object)value);
        this.currentThresholdSeverity = Severity.NORMAL;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public double getCurrentValue() {
        return this.values.length > 0 ? this.values[0].getValueAsDouble() : 0.0;
    }

    public String getCurrentValueAsString() {
        return this.values.length > 0 ? this.values[0].getValueAsString() : "";
    }

    public DciDataRow[] getValues() {
        return this.values;
    }

    public double getMinValue() {
        if (this.values.length == 0) {
            return 0.0;
        }
        double minValue = this.values[0].getValueAsDouble();
        for (int i = 1; i < this.values.length; ++i) {
            double curr = this.values[i].getValueAsDouble();
            if (!(curr < minValue)) continue;
            minValue = curr;
        }
        return minValue;
    }

    public double getMaxValue() {
        if (this.values.length == 0) {
            return 0.0;
        }
        double maxValue = this.values[0].getValueAsDouble();
        for (int i = 1; i < this.values.length; ++i) {
            double curr = this.values[i].getValueAsDouble();
            if (!(curr > maxValue)) continue;
            maxValue = curr;
        }
        return maxValue;
    }

    public double getAverageValue() {
        if (this.values.length == 0) {
            return 0.0;
        }
        double sum = this.values[0].getValueAsDouble();
        for (int i = 1; i < this.values.length; ++i) {
            sum += this.values[i].getValueAsDouble();
        }
        return sum / (double)this.values.length;
    }

    public Severity getActiveThresholdSeverity() {
        return this.currentThresholdSeverity;
    }

    public void setActiveThresholdSeverity(Severity severity) {
        this.currentThresholdSeverity = severity;
    }

    public String toString() {
        return "DataSeries [dataType=" + this.dataType + ", values=" + Arrays.toString(this.values) + ", currentThresholdSeverity=" + this.currentThresholdSeverity + "]";
    }
}

