/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusIndicatorConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.ObjectIdMatchingData;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.core.Persister;

public class StatusIndicatorConfig
extends DashboardElementConfig {
    public static final int SHAPE_CIRCLE = 0;
    public static final int SHAPE_RECTANGLE = 1;
    public static final int SHAPE_ROUNDED_RECTANGLE = 2;
    public static final int LABEL_NONE = 0;
    public static final int LABEL_INSIDE = 1;
    public static final int LABEL_OUTSIDE = 2;
    public static final int ELEMENT_TYPE_OBJECT = 0;
    public static final int ELEMENT_TYPE_DCI = 1;
    public static final int ELEMENT_TYPE_DCI_TEMPLATE = 2;
    public static final int ELEMENT_TYPE_SCRIPT = 3;
    @ElementArray(required=false)
    private StatusIndicatorElementConfig[] elements = new StatusIndicatorElementConfig[0];
    @Element(required=false)
    private long objectId = 0L;
    @Element(required=false)
    private String script = null;
    @Element(required=false)
    private long scriptContextObjectId = 0L;
    @Element(required=false)
    private int numColumns = 1;
    @Element(required=false)
    private boolean fullColorRange = false;
    @Element(required=false)
    private int shape = 0;
    @Element(required=false)
    private int labelType = 0;

    public static StatusIndicatorConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (StatusIndicatorConfig)serializer.read(StatusIndicatorConfig.class, xml);
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public Set<Long> getObjects() {
        Set objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    public boolean isFullColorRange() {
        return this.fullColorRange;
    }

    public void setFullColorRange(boolean fullColorRange) {
        this.fullColorRange = fullColorRange;
    }

    public StatusIndicatorElementConfig[] getElements() {
        if (this.elements.length == 0 && this.objectId != 0L) {
            StatusIndicatorElementConfig element = new StatusIndicatorElementConfig();
            element.setType(0);
            element.setObjectId(this.objectId);
            this.elements = new StatusIndicatorElementConfig[]{element};
        }
        return this.elements;
    }

    public void setElements(StatusIndicatorElementConfig[] elements) {
        this.elements = elements;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int labelType) {
        this.labelType = labelType;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public long getScriptContextObjectId() {
        return this.scriptContextObjectId;
    }

    public void setScriptContextObjectId(long scriptContextObjectId) {
        this.scriptContextObjectId = scriptContextObjectId;
    }
}

