/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.views.GraphBrowser;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class GraphsPerspective
extends Perspective {
    static final I18n i18n = LocalizationHelper.getI18n(GraphsPerspective.class);
    private NavigationView navigationView;
    private Object previousSelectedElement = null;

    public GraphsPerspective() {
        super("Graphs", i18n.tr("Graphs"), ResourceManager.getImage((String)"icons/perspective-graphs.png"));
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = true;
        configuration.multiViewNavigationArea = false;
        configuration.multiViewMainArea = false;
        configuration.hasSupplementalArea = false;
        configuration.priority = 140;
    }

    protected void configureViews() {
        this.navigationView = new GraphBrowser();
        this.addNavigationView(this.navigationView);
    }

    protected void navigationSelectionChanged(IStructuredSelection selection) {
        Object currentElement = selection.getFirstElement();
        if (this.previousSelectedElement == currentElement) {
            return;
        }
        if (currentElement != null && currentElement instanceof GraphDefinition) {
            HistoricalGraphView view = new HistoricalGraphView();
            view.setShowDeleteAction(true);
            this.setMainView((View)view);
            view.initPredefinedGraph((GraphDefinition)currentElement);
        } else {
            this.setMainView(null);
        }
        this.previousSelectedElement = currentElement;
    }
}

