/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logwatch.widgets;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.Section;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.base.widgets.helpers.ExpansionListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logwatch.dialogs.LogMacroEditDialog;
import org.netxms.nxmc.modules.logwatch.widgets.LogParserFileEditor;
import org.netxms.nxmc.modules.logwatch.widgets.LogParserRuleEditor;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParser;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserFile;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserModifyListener;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserRule;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserType;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.MacroListLabelProvider;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class LogParserEditor
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(LogParserEditor.class);
    private static final int TAB_NONE = 0;
    private static final int TAB_BUILDER = 1;
    private static final int TAB_XML = 2;
    private static final int DEFAULT_FILE_CHECK_INTERVAL = 10000;
    private final I18n i18n = LocalizationHelper.getI18n(LogParserEditor.class);
    private CTabFolder tabFolder;
    private int currentTab = 0;
    private Text xmlEditor;
    private Set<LogParserModifyListener> listeners = new HashSet();
    private boolean enableModifyListeners = true;
    private LogParser parser = new LogParser();
    private ScrolledComposite scroller;
    private Composite visualEditorArea;
    private Composite rulesArea;
    private Composite fileArea;
    private ImageHyperlink addRuleLink;
    private ImageHyperlink addFileLink;
    private SortableTableViewer macroList;
    private LogParserType type;
    private LabeledText textName;
    private Spinner spinnerFileCheckInterval;
    private Button checkProcessAll;

    public LogParserEditor(Composite parent, int style, LogParserType type) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.type = type;
        this.tabFolder = new CTabFolder((Composite)this, 8389634);
        this.tabFolder.setUnselectedImageVisible(true);
        WidgetHelper.disableTabFolderSelectionBar((CTabFolder)this.tabFolder);
        this.tabFolder.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createVisualEditor();
        this.createTextEditor();
        this.tabFolder.setSelection(0);
    }

    private void selectXmlEditor() {
        CTabItem tab = this.tabFolder.getSelection();
        if (tab != null && (Integer)tab.getData() == 2) {
            return;
        }
        for (CTabItem t : this.tabFolder.getItems()) {
            if ((Integer)t.getData() != 2) continue;
            this.tabFolder.setSelection(t);
            this.currentTab = 2;
            break;
        }
    }

    private void createVisualEditor() {
        this.scroller = new ScrolledComposite((Composite)this.tabFolder, 512);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.i18n.tr("Editor"));
        tabItem.setImage(SharedIcons.IMG_EDIT);
        tabItem.setControl((Control)this.scroller);
        tabItem.setData((Object)1);
        this.visualEditorArea = new Composite((Composite)this.scroller, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 8;
        layout.marginWidth = 8;
        layout.marginHeight = 8;
        this.visualEditorArea.setLayout((Layout)layout);
        this.visualEditorArea.setBackground(this.getDisplay().getSystemColor(25));
        this.scroller.setContent((Control)this.visualEditorArea);
        Section section = new Section(this.visualEditorArea, this.i18n.tr("General"), true);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.widthHint = 400;
        section.setLayoutData((Object)gd);
        section.addExpansionListener((ExpansionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createGeneralArea(section.getClient());
        section = new Section(this.visualEditorArea, this.i18n.tr("Macros"), true);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        section.addExpansionListener((ExpansionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createMacroSection(section.getClient());
        section = new Section(this.visualEditorArea, this.i18n.tr("Rules"), true);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        section.setLayoutData((Object)gd);
        this.rulesArea = section.getClient();
        GridLayout rulesAreaLayout = new GridLayout();
        rulesAreaLayout.marginHeight = 0;
        rulesAreaLayout.marginWidth = 0;
        rulesAreaLayout.verticalSpacing = 1;
        this.rulesArea.setLayout((Layout)rulesAreaLayout);
        this.rulesArea.setBackground(this.visualEditorArea.getBackground());
        this.addRuleLink = new ImageHyperlink(this.rulesArea, 0);
        this.addRuleLink.setText(this.i18n.tr("Add rule"));
        this.addRuleLink.setImage(SharedIcons.IMG_ADD_OBJECT);
        this.addRuleLink.setBackground(this.rulesArea.getBackground());
        this.addRuleLink.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateScroller() {
        this.visualEditorArea.layout(true, true);
        this.visualEditorArea.requestLayout();
        this.scroller.setMinSize(this.visualEditorArea.computeSize(this.scroller.getSize().x, -1));
    }

    private void createGeneralArea(Composite generalArea) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        generalArea.setLayout((Layout)layout);
        this.textName = new LabeledText(generalArea, 0);
        this.textName.setLabel(this.i18n.tr("Parser name"));
        this.textName.setText(this.parser.getName() != null ? this.parser.getName() : "");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = this.type == LogParserType.POLICY ? 1 : 2;
        gd.verticalAlignment = 1024;
        this.textName.setLayoutData((Object)gd);
        this.textName.getTextControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.type == LogParserType.POLICY) {
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1024;
            this.spinnerFileCheckInterval = WidgetHelper.createLabeledSpinner((Composite)generalArea, (int)2048, (String)this.i18n.tr("File check interval"), (int)1000, (int)60000, (Object)gd);
            this.spinnerFileCheckInterval.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            this.spinnerFileCheckInterval.setSelection(this.parser.getFileCheckInterval() != null ? this.parser.getFileCheckInterval() : 10000);
        }
        this.checkProcessAll = new Button(generalArea, 32);
        this.checkProcessAll.setText(this.i18n.tr("Always process all rules"));
        this.checkProcessAll.setSelection(this.parser.getProcessALL());
        this.checkProcessAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.type == LogParserType.POLICY) {
            this.fileArea = new Composite(generalArea, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.fileArea.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalSpan = 3;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.fileArea.setLayoutData((Object)gd);
            this.addFileLink = new ImageHyperlink(this.fileArea, 0);
            this.addFileLink.setText(this.i18n.tr("Add file"));
            this.addFileLink.setImage(SharedIcons.IMG_ADD_OBJECT);
            this.addFileLink.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void createTextEditor() {
        this.xmlEditor = new Text((Composite)this.tabFolder, 770);
        this.xmlEditor.setFont(JFaceResources.getTextFont());
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText("XML");
        tabItem.setImage(SharedIcons.IMG_XML);
        tabItem.setControl((Control)this.xmlEditor);
        tabItem.setData((Object)2);
        this.xmlEditor.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createMacroSection(Composite macroArea) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        macroArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{this.i18n.tr("Name"), this.i18n.tr("Value")};
        int[] columnWidths = new int[]{100, 200};
        this.macroList = new SortableTableViewer(macroArea, columnNames, columnWidths, 0, 128, 2048);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        gd.heightHint = 200;
        Table table = this.macroList.getTable();
        table.setLayoutData((Object)gd);
        this.macroList.setLabelProvider((IBaseLabelProvider)new MacroListLabelProvider());
        this.macroList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.macroList.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink link = new ImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        link.setText(this.i18n.tr("Add"));
        link.setBackground(macroArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        link = new ImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_EDIT);
        link.setText(this.i18n.tr("Edit"));
        link.setBackground(macroArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        link = new ImageHyperlink(macroArea, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.setText(this.i18n.tr("Delete"));
        link.setBackground(macroArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addModifyListener(LogParserModifyListener modifyListener) {
        this.listeners.add(modifyListener);
    }

    public void removeModifyListener(LogParserModifyListener modifyListener) {
        this.listeners.remove(modifyListener);
    }

    public void fireModifyListeners() {
        if (this.enableModifyListeners) {
            for (LogParserModifyListener l : this.listeners) {
                l.modifyParser();
            }
        }
    }

    public String getParserXml() {
        switch (this.currentTab) {
            case 1: {
                return this.buildParserXml();
            }
            case 2: {
                return this.xmlEditor.getText();
            }
        }
        return "<parser></parser>";
    }

    private String buildParserXml() {
        if (this.type == LogParserType.POLICY) {
            for (LogParserFile file : this.parser.getFiles()) {
                file.getEditor().save();
            }
            this.parser.setFileCheckInterval(Integer.valueOf(this.spinnerFileCheckInterval.getSelection()));
        }
        this.parser.setName(this.textName.getText());
        this.parser.setProcessALL(this.checkProcessAll.getSelection());
        for (LogParserRule rule : this.parser.getRules()) {
            rule.getEditor().save();
        }
        try {
            return this.parser.createXml();
        }
        catch (Exception e) {
            logger.error("Unexpected error creating parser XML", (Throwable)e);
            return "<parser>\n</parser>";
        }
    }

    public void setParserXml(String xml) {
        this.enableModifyListeners = false;
        this.xmlEditor.setText(xml);
        this.updateBuilderFromXml(xml);
        this.enableModifyListeners = true;
    }

    private void updateBuilderFromXml(String xml) {
        if (this.parser != null) {
            for (LogParserFile file : this.parser.getFiles()) {
                file.getEditor().dispose();
            }
            for (LogParserRule rule : this.parser.getRules()) {
                rule.getEditor().dispose();
            }
        }
        try {
            this.parser = LogParser.createFromXml((String)xml);
        }
        catch (Exception e) {
            logger.error("Error creating log parser object from XML", (Throwable)e);
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Log parser definition is invalid"));
            this.parser = null;
            this.selectXmlEditor();
            return;
        }
        this.parser.setSyslogParser(this.type);
        if (this.type == LogParserType.POLICY) {
            for (LogParserFile file : this.parser.getFiles()) {
                this.createFileEditor(file).moveAbove((Control)this.addFileLink);
            }
            this.spinnerFileCheckInterval.setSelection(this.parser.getFileCheckInterval() != null ? this.parser.getFileCheckInterval() : 10000);
        }
        this.textName.setText(this.parser.getName());
        this.checkProcessAll.setSelection(this.parser.getProcessALL());
        for (LogParserRule rule : this.parser.getRules()) {
            this.createRuleEditor(rule).moveAbove((Control)this.addRuleLink);
        }
        this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
        this.updateScroller();
    }

    private LogParserRuleEditor createRuleEditor(LogParserRule rule) {
        LogParserRuleEditor editor = new LogParserRuleEditor(this.rulesArea, rule, this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData((Object)gd);
        rule.setEditor(editor);
        return editor;
    }

    private void addRule() {
        LogParserRule rule = new LogParserRule();
        LogParserRuleEditor editor = this.createRuleEditor(rule);
        editor.moveAbove((Control)this.addRuleLink);
        this.parser.getRules().add(rule);
        this.updateScroller();
        this.fireModifyListeners();
    }

    private LogParserFileEditor createFileEditor(LogParserFile file) {
        LogParserFileEditor editor = new LogParserFileEditor(this.fileArea, file, this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData((Object)gd);
        file.setEditor(editor);
        return editor;
    }

    private void addFile() {
        LogParserFile file = new LogParserFile();
        LogParserFileEditor editor = this.createFileEditor(file);
        editor.moveAbove((Control)this.addFileLink);
        this.parser.getFiles().add(file);
        this.updateScroller();
        this.fireModifyListeners();
    }

    private void addMacro() {
        LogMacroEditDialog dlg = new LogMacroEditDialog(this.getShell(), null, null);
        if (dlg.open() == 0) {
            this.parser.getMacros().put(dlg.getName(), dlg.getValue());
            this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
            this.fireModifyListeners();
        }
    }

    private void editMacro() {
        IStructuredSelection selection = this.macroList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry e = (Map.Entry)selection.getFirstElement();
        LogMacroEditDialog dlg = new LogMacroEditDialog(this.getShell(), (String)e.getKey(), (String)e.getValue());
        if (dlg.open() == 0) {
            this.parser.getMacros().put(dlg.getName(), dlg.getValue());
            this.macroList.setInput((Object)this.parser.getMacros().entrySet().toArray());
            this.fireModifyListeners();
        }
    }

    private void deleteMacro() {
        IStructuredSelection selection = this.macroList.getStructuredSelection();
        if (selection.size() == 0) {
            return;
        }
        Map macros = this.parser.getMacros();
        for (Object o : selection.toList()) {
            macros.remove(((Map.Entry)o).getKey());
        }
        this.macroList.setInput((Object)macros.entrySet().toArray());
        this.fireModifyListeners();
    }

    public void deleteRule(LogParserRule rule) {
        this.parser.getRules().remove(rule);
        rule.getEditor().dispose();
        this.updateScroller();
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void deleteFile(LogParserFile file) {
        this.parser.getFiles().remove(file);
        file.getEditor().dispose();
        this.updateScroller();
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void moveRuleUp(LogParserRule rule) {
        int index = this.parser.getRules().indexOf(rule);
        if (index < 1) {
            return;
        }
        rule.getEditor().moveAbove((Control)((LogParserRule)this.parser.getRules().get(index - 1)).getEditor());
        Collections.swap(this.parser.getRules(), index - 1, index);
        this.updateScroller();
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public void moveRuleDown(LogParserRule rule) {
        int index = this.parser.getRules().indexOf(rule);
        if (index < 0 || index >= this.parser.getRules().size() - 1) {
            return;
        }
        rule.getEditor().moveBelow((Control)((LogParserRule)this.parser.getRules().get(index + 1)).getEditor());
        Collections.swap(this.parser.getRules(), index + 1, index);
        this.updateScroller();
        this.getParent().layout(true, true);
        this.fireModifyListeners();
    }

    public LogParserType getParserType() {
        return this.type;
    }

    public boolean isWindowsEventLogParser() {
        boolean isWindowsEventLogParser = false;
        for (LogParserFile file : this.parser.getFiles()) {
            if (!file.getEditor().getFile().startsWith("*")) continue;
            isWindowsEventLogParser = true;
            break;
        }
        return isWindowsEventLogParser;
    }

    public void updateRules() {
        for (LogParserRule rule : this.parser.getRules()) {
            if (rule.getEditor() == null) continue;
            rule.getEditor().updateWindowsEventLogFields();
        }
    }

    public boolean isEditorTabSelected() {
        return this.currentTab == 2;
    }
}

