/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.actions;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.CreateInterfaceDciDialog;
import org.netxms.nxmc.modules.objects.dialogs.helpers.InterfaceDciInfo;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class CreateInterfaceDciAction
extends Action {
    private static final int IFDCI_IN_BYTES = 0;
    private static final int IFDCI_OUT_BYTES = 1;
    private static final int IFDCI_IN_BITS = 2;
    private static final int IFDCI_OUT_BITS = 3;
    private static final int IFDCI_IN_PACKETS = 4;
    private static final int IFDCI_OUT_PACKETS = 5;
    private static final int IFDCI_IN_ERRORS = 6;
    private static final int IFDCI_OUT_ERRORS = 7;
    private final I18n i18n = LocalizationHelper.getI18n(CreateInterfaceDciAction.class);
    private View view;
    private ISelectionProvider selectionProvider;

    public CreateInterfaceDciAction(String text, View view, ISelectionProvider selectionProvider) {
        super(text);
        this.view = view;
        this.selectionProvider = selectionProvider;
    }

    public void run() {
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        for (Object o : ((IStructuredSelection)this.selectionProvider.getSelection()).toList()) {
            if (!(o instanceof Interface)) continue;
            interfaces.add((Interface)o);
        }
        if (interfaces.isEmpty()) {
            return;
        }
        CreateInterfaceDciDialog dlg = new CreateInterfaceDciDialog(this.view.getWindow().getShell(), interfaces.size() == 1 ? (Interface)interfaces.get(0) : null);
        if (dlg.open() != 0) {
            return;
        }
        HashSet<AbstractNode> nodes = new HashSet<AbstractNode>();
        for (Interface iface : interfaces) {
            AbstractNode node = iface.getParentNode();
            if (node == null) continue;
            nodes.add(node);
        }
        NXCSession session = Registry.getSession();
        String taskName = this.i18n.tr("Creating interface DCIs");
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private static void createInterfaceDci(NXCSession session, Interface iface, int dciType, InterfaceDciInfo dciInfo, int pollingScheduleType, int pollingInterval, int retentionType, int retentionTime, boolean updateDescription) throws Exception {
        AbstractNode node = iface.getParentNode();
        if (node == null) {
            throw new NXCException(46);
        }
        DataCollectionConfiguration dcc = new DataCollectionConfiguration(session, node.getObjectId());
        DataCollectionItem dci = new DataCollectionItem(dcc, 0L);
        dci.setPollingScheduleType(pollingScheduleType);
        dci.setPollingInterval(Integer.toString(pollingInterval));
        dci.setRetentionType(retentionType);
        dci.setRetentionTime(Integer.toString(retentionTime));
        if (node.hasAgent()) {
            dci.setOrigin(DataOrigin.AGENT);
            if (node.isAgentIfXCountersSupported()) {
                dci.setDataType(dciType != 6 && dciType != 7 ? DataType.COUNTER64 : DataType.COUNTER32);
            } else {
                dci.setDataType(DataType.COUNTER32);
            }
        } else {
            dci.setOrigin(DataOrigin.SNMP);
            if (node.isIfXTableSupported()) {
                dci.setDataType(dciType != 6 && dciType != 7 ? DataType.COUNTER64 : DataType.COUNTER32);
            } else {
                dci.setDataType(DataType.COUNTER32);
            }
        }
        dci.setStatus(0);
        dci.setDescription(updateDescription ? dciInfo.description.replaceAll("@@ifName@@", iface.getObjectName()) : dciInfo.description);
        dci.setDeltaCalculation(dciInfo.delta ? 2 : 0);
        dci.setRelatedObject(iface.getObjectId());
        if (dci.getOrigin() == DataOrigin.AGENT) {
            switch (dciType) {
                case 0: 
                case 2: {
                    dci.setName((node.isAgentIfXCountersSupported() ? "Net.Interface.BytesIn64(" : "Net.Interface.BytesIn(") + iface.getIfIndex() + ")");
                    break;
                }
                case 1: 
                case 3: {
                    dci.setName((node.isAgentIfXCountersSupported() ? "Net.Interface.BytesOut64(" : "Net.Interface.BytesOut(") + iface.getIfIndex() + ")");
                    break;
                }
                case 4: {
                    dci.setName((node.isAgentIfXCountersSupported() ? "Net.Interface.PacketsIn64(" : "Net.Interface.PacketsIn(") + iface.getIfIndex() + ")");
                    break;
                }
                case 5: {
                    dci.setName((node.isAgentIfXCountersSupported() ? "Net.Interface.PacketsOut64(" : "Net.Interface.PacketsOut(") + iface.getIfIndex() + ")");
                    break;
                }
                case 6: {
                    dci.setName("Net.Interface.InErrors(" + iface.getIfIndex() + ")");
                    break;
                }
                case 7: {
                    dci.setName("Net.Interface.OutErrors(" + iface.getIfIndex() + ")");
                }
            }
        } else {
            switch (dciType) {
                case 0: 
                case 2: {
                    dci.setName((node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.6" : ".1.3.6.1.2.1.2.2.1.10") + CreateInterfaceDciAction.getInterfaceInstance((Interface)iface));
                    break;
                }
                case 1: 
                case 3: {
                    dci.setName((node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.10" : ".1.3.6.1.2.1.2.2.1.16") + CreateInterfaceDciAction.getInterfaceInstance((Interface)iface));
                    break;
                }
                case 4: {
                    dci.setName((node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.7" : ".1.3.6.1.2.1.2.2.1.11") + CreateInterfaceDciAction.getInterfaceInstance((Interface)iface));
                    break;
                }
                case 5: {
                    dci.setName((node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.11" : ".1.3.6.1.2.1.2.2.1.17") + CreateInterfaceDciAction.getInterfaceInstance((Interface)iface));
                    break;
                }
                case 6: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.14" + CreateInterfaceDciAction.getInterfaceInstance((Interface)iface));
                    break;
                }
                case 7: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.20" + CreateInterfaceDciAction.getInterfaceInstance((Interface)iface));
                }
            }
        }
        switch (dciType) {
            case 0: 
            case 1: {
                dci.setUnitName(dciInfo.delta ? "B/s" : "B (Metric)");
                break;
            }
            case 2: 
            case 3: {
                dci.setUnitName(dciInfo.delta ? "b/s" : "b (Metric)");
                break;
            }
            case 4: 
            case 5: {
                dci.setUnitName(dciInfo.delta ? "packets/s" : "packets");
                break;
            }
            case 6: 
            case 7: {
                dci.setUnitName(dciInfo.delta ? "errors/s" : "errors");
            }
        }
        if (dciType == 2 || dciType == 3) {
            dci.setTransformationScript("return $1 * 8;");
        }
        dcc.modifyObject((DataCollectionObject)dci);
    }

    private static String getInterfaceInstance(Interface iface) {
        return iface.getIfTableSuffix().getLength() > 0 ? iface.getIfTableSuffix().toString() : "." + iface.getIfIndex();
    }
}

