/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.EntityMIBView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.ComponentTreeContentProvider;
import org.netxms.nxmc.modules.objects.views.helpers.ComponentTreeLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EntityMIBView
extends ObjectView {
    private static I18n i18n = LocalizationHelper.getI18n(EntityMIBView.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_CLASS = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int COLUMN_MODEL = 3;
    public static final int COLUMN_FIRMWARE = 4;
    public static final int COLUMN_SERIAL = 5;
    public static final int COLUMN_VENDOR = 6;
    public static final int COLUMN_INTERFACE = 7;
    private TreeViewer viewer;
    private ComponentTreeLabelProvider labelProvider;
    private Action actionCopy;
    private Action actionCopyName;
    private Action actionCopyModel;
    private Action actionCopySerial;
    private Action actionCollapseAll;
    private Action actionExpandAll;

    public EntityMIBView() {
        super(i18n.tr("Components"), ResourceManager.getImageDescriptor((String)"icons/object-views/components.png"), "EntityMIBView", false);
    }

    public boolean isValidForContext(Object context) {
        if (context != null && context instanceof Node) {
            return (((Node)context).getCapabilities() & 0x8000) != 0;
        }
        return false;
    }

    public int getPriority() {
        return 80;
    }

    protected void createContent(Composite parent) {
        this.viewer = new TreeViewer(parent, 65538);
        this.addColumn(i18n.tr("Name"), 200);
        this.addColumn(i18n.tr("Class"), 100);
        this.addColumn(i18n.tr("Description"), 250);
        this.addColumn(i18n.tr("Model"), 150);
        this.addColumn(i18n.tr("Firmware"), 100);
        this.addColumn(i18n.tr("Serial Number"), 150);
        this.addColumn(i18n.tr("Vendor"), 150);
        this.addColumn(i18n.tr("Interface"), 150);
        this.labelProvider = new ComponentTreeLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ComponentTreeContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        WidgetHelper.restoreColumnSettings((Tree)this.viewer.getTree(), (String)"ComponentTree");
        this.viewer.getTree().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
    }

    private void addColumn(String name, int width) {
        TreeViewerColumn tc = new TreeViewerColumn(this.viewer, 16384);
        tc.getColumn().setText(name);
        tc.getColumn().setWidth(width);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyName);
        manager.add((IAction)this.actionCopyModel);
        manager.add((IAction)this.actionCopySerial);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCollapseAll);
        manager.add((IAction)this.actionExpandAll);
    }

    private void createActions() {
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyName = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyModel = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopySerial = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCollapseAll = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExpandAll = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void copySelectionToClipboard(int column) {
        TreeItem[] selection = this.viewer.getTree().getSelection();
        if (selection.length > 0) {
            String newLine = SystemUtils.IS_OS_WINDOWS ? "\r\n" : "\n";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    sb.append(selection[i].getText(0));
                    for (int j = 1; j < this.viewer.getTree().getColumnCount(); ++j) {
                        sb.append("\t");
                        sb.append(selection[i].getText(j));
                    }
                    continue;
                }
                sb.append(selection[i].getText(column));
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    protected void onObjectChange(AbstractObject object) {
        this.viewer.setInput((Object)new Object[0]);
        if (object == null) {
            return;
        }
        9 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }
}

