/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.InetAddressListElement;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.Section;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptSelector;
import org.netxms.nxmc.modules.serverconfig.dialogs.AddressListElementEditDialog;
import org.netxms.nxmc.modules.serverconfig.views.NetworkDiscoveryConfigurator;
import org.netxms.nxmc.modules.serverconfig.views.helpers.AddressListElementComparator;
import org.netxms.nxmc.modules.serverconfig.views.helpers.AddressListLabelProvider;
import org.netxms.nxmc.modules.serverconfig.views.helpers.NetworkDiscoveryConfig;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class NetworkDiscoveryConfigurator
extends ConfigurationView {
    public static final int RANGE = 0;
    public static final int PROXY = 1;
    public static final int COMMENTS = 2;
    private static I18n i18n = LocalizationHelper.getI18n(NetworkDiscoveryConfigurator.class);
    private NetworkDiscoveryConfig config;
    private boolean modified = false;
    private Composite content;
    private Button radioDiscoveryOff;
    private Button radioDiscoveryPassive;
    private Button radioDiscoveryActive;
    private Button radioDiscoveryActiveAndPassive;
    private Button checkEnableTCPProbing;
    private Button checkUseSnmpTraps;
    private Button checkUseSyslog;
    private Spinner passiveDiscoveryInterval;
    private Label activeDiscoveryScheduleLabel;
    private Button radioActiveDiscoveryInterval;
    private Button radioActiveDiscoverySchedule;
    private Spinner activeDiscoveryInterval;
    private LabeledText activeDiscoverySchedule;
    private Button checkFilterRange;
    private Button checkFilterProtocols;
    private Button checkAllowAgent;
    private Button checkAllowSNMP;
    private Button checkAllowSSH;
    private Button checkFilterScript;
    private ScriptSelector filterScript;
    private SortableTableViewer filterAddressList;
    private SortableTableViewer activeDiscoveryAddressList;
    private Action actionSave;

    public NetworkDiscoveryConfigurator() {
        super(i18n.tr("Network Discovery"), ResourceManager.getImageDescriptor((String)"icons/config-views/network_credentials.png"), "NetworkCredentials", false);
    }

    public void createContent(Composite parent) {
        ScrolledComposite scroller = new ScrolledComposite(parent, 512);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)scroller, (int)512, (int)20);
        scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.content = new Composite((Composite)scroller, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.content.setLayout((Layout)layout);
        this.content.setBackground(this.content.getDisplay().getSystemColor(25));
        scroller.setContent((Control)this.content);
        this.createGeneralSection();
        this.createFilterSection();
        this.createScheduleSection();
        this.createActiveDiscoverySection();
        this.createActions();
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createActions() {
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    private void createGeneralSection() {
        Section section = new Section(this.content, i18n.tr("General"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        clientArea.setLayout((Layout)layout);
        4 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.radioDiscoveryOff = new Button(clientArea, 16);
        this.radioDiscoveryOff.setText(i18n.tr("Disabled"));
        this.radioDiscoveryOff.addSelectionListener((SelectionListener)listener);
        this.radioDiscoveryPassive = new Button(clientArea, 16);
        this.radioDiscoveryPassive.setText(i18n.tr("Passive only"));
        this.radioDiscoveryPassive.addSelectionListener((SelectionListener)listener);
        this.radioDiscoveryActive = new Button(clientArea, 16);
        this.radioDiscoveryActive.setText(i18n.tr("Active only"));
        this.radioDiscoveryActive.addSelectionListener((SelectionListener)listener);
        this.radioDiscoveryActiveAndPassive = new Button(clientArea, 16);
        this.radioDiscoveryActiveAndPassive.setText(i18n.tr("Active and passive"));
        this.radioDiscoveryActiveAndPassive.addSelectionListener((SelectionListener)listener);
        this.checkEnableTCPProbing = new Button(clientArea, 32);
        this.checkEnableTCPProbing.setText(i18n.tr("Enable TCP probing"));
        this.checkEnableTCPProbing.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.verticalIndent = 10;
        this.checkEnableTCPProbing.setLayoutData((Object)gd);
        this.checkUseSnmpTraps = new Button(clientArea, 32);
        this.checkUseSnmpTraps.setText(i18n.tr("Use SNMP trap source addresses for discovery"));
        this.checkUseSnmpTraps.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkUseSyslog = new Button(clientArea, 32);
        this.checkUseSyslog.setText(i18n.tr("Use syslog source addresses for discovery"));
        this.checkUseSyslog.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void enablePassiveDiscovery(boolean enabled) {
        this.passiveDiscoveryInterval.setEnabled(enabled);
    }

    private void enableActiveDiscovery(boolean enabled) {
        if (this.radioActiveDiscoveryInterval.getSelection()) {
            this.activeDiscoverySchedule.setEnabled(false);
        } else {
            this.activeDiscoveryInterval.setEnabled(false);
        }
        this.radioActiveDiscoveryInterval.setEnabled(enabled);
        this.radioActiveDiscoverySchedule.setEnabled(enabled);
        this.checkEnableTCPProbing.setEnabled(enabled);
    }

    private void createScheduleSection() {
        Section section = new Section(this.content, i18n.tr("Schedule"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.passiveDiscoveryInterval = WidgetHelper.createLabeledSpinner((Composite)clientArea, (int)2048, (String)i18n.tr("Passive discovery interval"), (int)0, (int)0xFFFFFF, (Object)gd);
        this.passiveDiscoveryInterval.setBackground(clientArea.getBackground());
        this.passiveDiscoveryInterval.getParent().setBackground(clientArea.getBackground());
        this.passiveDiscoveryInterval.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.activeDiscoveryScheduleLabel = new Label(clientArea, 16384);
        this.activeDiscoveryScheduleLabel.setText(i18n.tr("Active discovery schedule configuration"));
        this.activeDiscoveryScheduleLabel.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.activeDiscoveryScheduleLabel.setLayoutData((Object)gd);
        9 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.radioActiveDiscoveryInterval = new Button(clientArea, 16);
        this.radioActiveDiscoveryInterval.setText(i18n.tr("Interval"));
        this.radioActiveDiscoveryInterval.addSelectionListener((SelectionListener)listener);
        this.radioActiveDiscoverySchedule = new Button(clientArea, 16);
        this.radioActiveDiscoverySchedule.setText(i18n.tr("Schedule"));
        this.radioActiveDiscoverySchedule.addSelectionListener((SelectionListener)listener);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 16384;
        this.radioActiveDiscoverySchedule.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.activeDiscoveryInterval = WidgetHelper.createLabeledSpinner((Composite)clientArea, (int)2048, (String)i18n.tr("Active discovery interval"), (int)0, (int)0xFFFFFF, (Object)gd);
        this.activeDiscoveryInterval.setBackground(clientArea.getBackground());
        this.activeDiscoveryInterval.getParent().setBackground(clientArea.getBackground());
        this.activeDiscoveryInterval.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.activeDiscoverySchedule = new LabeledText(clientArea, 0, 2052);
        this.activeDiscoverySchedule.setLabel(i18n.tr("Active discovery schedule"));
        this.activeDiscoverySchedule.setBackground(clientArea.getBackground());
        this.activeDiscoverySchedule.getTextControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 16384;
        this.activeDiscoverySchedule.setLayoutData((Object)gd);
    }

    private void createFilterSection() {
        Section section = new Section(this.content, i18n.tr("Filter"), false);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 3;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        clientArea.setLayout((Layout)layout);
        12 checkBoxListener = new /* Unavailable Anonymous Inner Class!! */;
        this.checkFilterRange = new Button(clientArea, 32);
        this.checkFilterRange.setText(i18n.tr("By address range"));
        this.checkFilterRange.addSelectionListener((SelectionListener)checkBoxListener);
        Composite addressRangeEditor = new Composite(clientArea, 0);
        addressRangeEditor.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.horizontalIndent = 20;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        addressRangeEditor.setLayoutData((Object)gd);
        GridLayout addressRangeLayout = new GridLayout();
        addressRangeLayout.numColumns = 2;
        addressRangeEditor.setLayout((Layout)addressRangeLayout);
        String[] names = new String[]{i18n.tr("Range"), i18n.tr("Comment")};
        int[] widths = new int[]{150, 150};
        this.filterAddressList = new SortableTableViewer(addressRangeEditor, names, widths, 0, 1024, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        gd.heightHint = 300;
        this.filterAddressList.getTable().setLayoutData((Object)gd);
        this.filterAddressList.getTable().setSortDirection(128);
        this.filterAddressList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.filterAddressList.setLabelProvider((IBaseLabelProvider)new AddressListLabelProvider(false));
        this.filterAddressList.setComparator((ViewerComparator)new AddressListElementComparator(false));
        this.filterAddressList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkAdd = new ImageHyperlink(addressRangeEditor, 0);
        linkAdd.setText(i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkEdit = new ImageHyperlink(addressRangeEditor, 0);
        linkEdit.setText(i18n.tr("Edit..."));
        linkEdit.setImage(SharedIcons.IMG_EDIT);
        linkEdit.setBackground(clientArea.getBackground());
        linkEdit.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkEdit.setLayoutData((Object)gd);
        linkEdit.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(addressRangeEditor, 0);
        linkRemove.setText(i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        linkRemove.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        this.filterAddressList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkFilterProtocols = new Button(clientArea, 32);
        this.checkFilterProtocols.setText(i18n.tr("By communication protocols"));
        this.checkFilterProtocols.addSelectionListener((SelectionListener)checkBoxListener);
        this.checkAllowAgent = new Button(clientArea, 32);
        this.checkAllowAgent.setText(i18n.tr("Accept node if it has &NetXMS agent"));
        this.checkAllowAgent.addSelectionListener((SelectionListener)checkBoxListener);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.checkAllowAgent.setLayoutData((Object)gd);
        this.checkAllowSNMP = new Button(clientArea, 32);
        this.checkAllowSNMP.setText(i18n.tr("Accept node if it has &SNMP agent"));
        this.checkAllowSNMP.addSelectionListener((SelectionListener)checkBoxListener);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.checkAllowSNMP.setLayoutData((Object)gd);
        this.checkAllowSSH = new Button(clientArea, 32);
        this.checkAllowSSH.setText(i18n.tr("Accept node if it is accessible via SS&H"));
        this.checkAllowSSH.addSelectionListener((SelectionListener)checkBoxListener);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.checkAllowSSH.setLayoutData((Object)gd);
        this.checkFilterScript = new Button(clientArea, 32);
        this.checkFilterScript.setText(i18n.tr("With custom script"));
        this.checkFilterScript.addSelectionListener((SelectionListener)checkBoxListener);
        this.filterScript = new ScriptSelector(clientArea, 0, true, false);
        this.filterScript.setBackground(clientArea.getBackground());
        this.filterScript.getTextControl().setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.filterScript.setLayoutData((Object)gd);
        this.filterScript.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createActiveDiscoverySection() {
        Section section = new Section(this.content, i18n.tr("Active discovery targets"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        clientArea.setBackground(this.content.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        String[] names = new String[]{i18n.tr("Range"), i18n.tr("Proxy"), i18n.tr("Comments")};
        int[] widths = new int[]{150, 150, 150};
        this.activeDiscoveryAddressList = new SortableTableViewer(clientArea, names, widths, 0, 1024, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.activeDiscoveryAddressList.getTable().setLayoutData((Object)gd);
        this.activeDiscoveryAddressList.getTable().setSortDirection(128);
        this.activeDiscoveryAddressList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.activeDiscoveryAddressList.setLabelProvider((IBaseLabelProvider)new AddressListLabelProvider(true));
        this.activeDiscoveryAddressList.setComparator((ViewerComparator)new AddressListElementComparator(true));
        this.activeDiscoveryAddressList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkEdit = new ImageHyperlink(controlArea, 0);
        linkEdit.setText(i18n.tr("Edit..."));
        linkEdit.setImage(SharedIcons.IMG_EDIT);
        linkEdit.setBackground(clientArea.getBackground());
        linkEdit.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkEdit.setLayoutData((Object)gd);
        linkEdit.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        linkRemove.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink runActiveDiscovery = new ImageHyperlink(controlArea, 0);
        runActiveDiscovery.setText(i18n.tr("Scan"));
        runActiveDiscovery.setToolTipText(i18n.tr("Runs active discovery on selected ranges"));
        runActiveDiscovery.setImage(SharedIcons.IMG_EXECUTE);
        runActiveDiscovery.setBackground(clientArea.getBackground());
        runActiveDiscovery.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 128;
        runActiveDiscovery.setLayoutData((Object)gd);
        runActiveDiscovery.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        this.activeDiscoveryAddressList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setFocus() {
        this.content.setFocus();
    }

    public void setConfig(NetworkDiscoveryConfig config) {
        this.config = config;
        this.radioDiscoveryOff.setSelection(config.getDiscoveryType() == 0);
        this.radioDiscoveryPassive.setSelection(config.getDiscoveryType() == 1);
        this.radioDiscoveryActive.setSelection(config.getDiscoveryType() == 2);
        this.radioDiscoveryActiveAndPassive.setSelection(config.getDiscoveryType() == 3);
        this.checkEnableTCPProbing.setSelection(config.isEnableTCPProbing());
        this.checkUseSnmpTraps.setSelection(config.isUseSnmpTraps());
        this.checkUseSyslog.setSelection(config.isUseSyslog());
        this.passiveDiscoveryInterval.setSelection(config.getPassiveDiscoveryPollInterval());
        if (config.getActiveDiscoveryPollInterval() != 0) {
            this.radioActiveDiscoveryInterval.setSelection(true);
        } else {
            this.radioActiveDiscoverySchedule.setSelection(true);
        }
        this.activeDiscoveryInterval.setSelection(config.getActiveDiscoveryPollInterval());
        this.activeDiscoverySchedule.setText(config.getActiveDiscoveryPollSchedule());
        this.enableActiveDiscovery(config.getDiscoveryType() == 2 || config.getDiscoveryType() == 3);
        this.enablePassiveDiscovery(config.getDiscoveryType() == 1 || config.getDiscoveryType() == 3);
        this.checkFilterRange.setSelection((config.getFilterFlags() & 2) != 0);
        this.checkFilterScript.setSelection((config.getFilterFlags() & 4) != 0);
        this.checkFilterProtocols.setSelection((config.getFilterFlags() & 1) != 0);
        this.checkAllowAgent.setSelection((config.getFilterFlags() & 0x100) != 0);
        this.checkAllowSNMP.setSelection((config.getFilterFlags() & 0x200) != 0);
        this.checkAllowSSH.setSelection((config.getFilterFlags() & 0x400) != 0);
        this.activeDiscoveryAddressList.setInput((Object)config.getTargets().toArray());
        this.filterAddressList.setInput((Object)config.getAddressFilter().toArray());
        this.filterScript.setScriptName(config.getFilterScript());
        this.modified = false;
    }

    private void setModified() {
        this.modified = true;
    }

    public void save() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void addTargetAddressListElement() {
        InetAddressListElement element;
        List list;
        AddressListElementEditDialog dlg = new AddressListElementEditDialog(this.getWindow().getShell(), true, null);
        if (dlg.open() == 0 && !(list = this.config.getTargets()).contains(element = dlg.getElement())) {
            list.add(element);
            this.activeDiscoveryAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void editTargetAddressListElement() {
        IStructuredSelection selection = this.activeDiscoveryAddressList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AddressListElementEditDialog dlg = new AddressListElementEditDialog(this.getWindow().getShell(), true, (InetAddressListElement)selection.getFirstElement());
        if (dlg.open() == 0) {
            List list = this.config.getTargets();
            this.activeDiscoveryAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void removeTargetAddressListElements() {
        List list = this.config.getTargets();
        IStructuredSelection selection = (IStructuredSelection)this.activeDiscoveryAddressList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.activeDiscoveryAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void scanAddressRange() {
        IStructuredSelection selection = this.activeDiscoveryAddressList.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)i18n.tr("Active Discovery"), (String)i18n.tr("Are you sure you want to start manual scan for selected ranges?"))) {
            return;
        }
        ArrayList<InetAddressListElement> list = new ArrayList<InetAddressListElement>();
        for (Object o : selection.toList()) {
            list.add((InetAddressListElement)o);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void addAddressFilterElement() {
        InetAddressListElement element;
        List list;
        AddressListElementEditDialog dlg = new AddressListElementEditDialog(this.getWindow().getShell(), false, null);
        if (dlg.open() == 0 && !(list = this.config.getAddressFilter()).contains(element = dlg.getElement())) {
            list.add(element);
            this.filterAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void editAddressFilterElement() {
        IStructuredSelection selection = this.filterAddressList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AddressListElementEditDialog dlg = new AddressListElementEditDialog(this.getWindow().getShell(), false, (InetAddressListElement)selection.getFirstElement());
        if (dlg.open() == 0) {
            List list = this.config.getAddressFilter();
            this.filterAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    private void removeAddressFilterElements() {
        List list = this.config.getAddressFilter();
        IStructuredSelection selection = (IStructuredSelection)this.filterAddressList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                list.remove(o);
            }
            this.filterAddressList.setInput((Object)list.toArray());
            this.setModified();
        }
    }

    public boolean isModified() {
        return this.modified;
    }
}

