/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.propertypages;

import java.util.HashMap;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.UserGroup;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.views.helpers.BaseUserLabelProvider;
import org.xnap.commons.i18n.I18n;

public class Members
extends PropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(Members.class);
    private TableViewer userList;
    private NXCSession session;
    private UserGroup object;
    private HashMap<Long, AbstractUserObject> members = new HashMap(0);

    public Members(UserGroup user) {
        super(i18n.tr("Members"));
        this.session = Registry.getSession();
        this.object = user;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        if (this.object.getId() == 0x40000000L) {
            GridLayout layout = new GridLayout();
            dialogArea.setLayout((Layout)layout);
            Label label = new Label(dialogArea, 0x1000040);
            label.setText("This built-in group contains all the users in the system and\nis populated automatically. You can\u2019t add or remove users here.");
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.userList = new TableViewer(dialogArea, 67586);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new BaseUserLabelProvider());
        this.userList.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.userList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText(i18n.tr("&Add..."));
        addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button deleteButton = new Button(buttons, 8);
        deleteButton.setText(i18n.tr("&Delete"));
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.userList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        for (long userId : this.object.getMembers()) {
            AbstractUserObject user = this.session.findUserDBObjectById(userId, null);
            if (user == null) continue;
            this.members.put(user.getId(), user);
        }
        this.userList.setInput((Object)this.members.values().toArray());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        long[] memberIds = new long[this.members.size()];
        int i = 0;
        for (Long id : this.members.keySet()) {
            memberIds[i++] = id;
        }
        this.object.setMembers(memberIds);
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

