/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.xnap.commons.i18n.I18n;

public class IPAddressValidator
implements TextFieldValidator {
    private static final String IP_ADDRESS_PATTERN = "^([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}|[A-Fa-f0-9:]+)$";
    private I18n i18n = LocalizationHelper.getI18n(IPAddressValidator.class);
    private boolean allowEmpty;

    public IPAddressValidator(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public boolean validate(String text) {
        if (this.allowEmpty && text.trim().isEmpty()) {
            return true;
        }
        return text.matches(IP_ADDRESS_PATTERN);
    }

    public String getErrorMessage(String text, String label) {
        return String.format(this.i18n.tr("Please enter valid IP address in \"%s\" field"), label);
    }
}

