/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.views;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.ProgressListener;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.server.ServerFile;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.filemanager.Activator;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.views.helpers.ServerFileComparator;
import org.netxms.ui.eclipse.filemanager.views.helpers.ServerFileFilter;
import org.netxms.ui.eclipse.filemanager.views.helpers.ServerFileLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ServerFileManager
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.usermanager.view.server_files";
    private static final String TABLE_CONFIG_PREFIX = "ServerFilesEditor";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_SIZE = 2;
    public static final int COLUMN_MODIFYED = 3;
    private boolean initShowFilter = true;
    private Composite content;
    private ServerFile[] files;
    private ServerFileFilter filter;
    private FilterText filterText;
    private SortableTableViewer viewer;
    private NXCSession session;
    private Action actionRefresh;
    private Action actionUpload;
    private Action actionRename;
    private Action actionDelete;
    private Action actionShowFilter;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = ServerFileManager.safeCast(settings.get("ServerFileManager.showFilter"), settings.getBoolean("ServerFileManager.showFilter"), this.initShowFilter);
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void createPartControl(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerFileManager.this.onFilterModify();
            }
        });
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.ViewServerFile_FileName;
        Messages.get();
        stringArray[1] = Messages.ViewServerFile_FileType;
        Messages.get();
        stringArray[2] = Messages.ViewServerFile_FileSize;
        Messages.get();
        stringArray[3] = Messages.ViewServerFile_ModificationDate;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{300, 150, 300, 300};
        this.viewer = new SortableTableViewer(this.content, columnNames, columnWidths, 0, 128, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerFileComparator());
        this.filter = new ServerFileFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ServerFileManager.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ServerFileManager.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)ServerFileManager.TABLE_CONFIG_PREFIX);
            }
        });
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 4;
            }
        }, (int)1);
        TextCellEditor editor = new TextCellEditor((Composite)this.viewer.getTable(), 2048);
        this.viewer.setCellEditors(new CellEditor[]{editor});
        this.viewer.setColumnProperties(new String[]{"name"});
        this.viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                Object data;
                Object object = data = element instanceof Item ? ((Item)element).getData() : element;
                if (property.equals("name") && data instanceof ServerFile) {
                    final String newName = value.toString();
                    new ConsoleJob("Rename server file", (IWorkbenchPart)ServerFileManager.this, "org.netxms.ui.eclipse.filemanager"){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            (this).ServerFileManager.this.session.renameServerFile(((ServerFile)data).getName(), newName);
                        }

                        protected String getErrorMessage() {
                            return String.format("Cannot rename server file \"%s\"", ((ServerFile)data).getName());
                        }
                    }.start();
                }
            }

            public Object getValue(Object element, String property) {
                if (property.equals("name") && element instanceof ServerFile) {
                    return ((ServerFile)element).getName();
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return property.equals("name");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        this.session.addListener((SessionListener)this);
        this.filterText.setCloseAction(this.actionShowFilter);
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.refreshFileList();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.filemanager.context.FileManager");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ServerFileManager.this.refreshFileList();
            }
        };
        this.actionUpload = new Action("&Upload...", SharedIcons.UPLOAD){

            public void run() {
                ServerFileManager.this.uploadFile();
            }
        };
        this.actionRename = new Action("&Rename"){

            public void run() {
                IStructuredSelection selection = ServerFileManager.this.viewer.getStructuredSelection();
                if (selection.size() == 1) {
                    ServerFileManager.this.viewer.editElement(selection.getFirstElement(), 0);
                }
            }
        };
        this.actionDelete = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                ServerFileManager.this.deleteFile();
            }
        };
        Messages.get();
        this.actionShowFilter = new Action(Messages.ViewServerFile_ShowFilterAction, 2){

            public void run() {
                ServerFileManager.this.enableFilter(!ServerFileManager.this.initShowFilter);
                ServerFileManager.this.actionShowFilter.setChecked(ServerFileManager.this.initShowFilter);
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.showFilter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionUpload);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionUpload);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ServerFileManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionRename);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionUpload);
    }

    private void refreshFileList() {
        Messages.get();
        new ConsoleJob(Messages.SelectServerFileDialog_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerFileManager.this.files = ServerFileManager.this.session.listServerFiles();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ServerFileManager.this.viewer.setInput((Object)(this).ServerFileManager.this.files);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectServerFileDialog_JobError;
            }
        }.start();
    }

    private void uploadFile() {
        FileDialog fd = new FileDialog(this.getSite().getShell(), 4098);
        fd.setText("Select Files");
        String selection = fd.open();
        if (selection == null) {
            return;
        }
        final ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = fd.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fname = stringArray[n2];
            files.add(fname.charAt(0) == File.separatorChar ? new File(fname) : new File(new File(selection).getParentFile(), fname));
            ++n2;
        }
        Messages.get();
        new ConsoleJob(Messages.UploadFileToServer_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager"){

            protected void runInternal(final IProgressMonitor monitor) throws Exception {
                for (final File localFile : files) {
                    String remoteFile = localFile.getName();
                    ServerFileManager.this.session.uploadFileToServer(localFile, remoteFile, new ProgressListener(){
                        private long prevWorkDone = 0L;

                        public void setTotalWorkAmount(long workTotal) {
                            Messages.get();
                            monitor.beginTask(String.valueOf(Messages.UploadFileToServer_TaskNamePrefix) + localFile.getAbsolutePath(), (int)workTotal);
                        }

                        public void markProgress(long workDone) {
                            monitor.worked((int)(workDone - this.prevWorkDone));
                            this.prevWorkDone = workDone;
                        }
                    });
                    monitor.done();
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.UploadFileToServer_JobError;
            }
        }.start();
    }

    private void deleteFile() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.ViewServerFile_DeleteConfirmation, (String)Messages.ViewServerFile_DeletAck)) {
            return;
        }
        final Object[] objects = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.ViewServerFile_DeletFileFromServerJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ViewServerFile_ErrorDeleteFileJob;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    ServerFileManager.this.session.deleteServerFile(((ServerFile)objects[i]).getName());
                    ++i;
                }
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 1025) {
            this.refreshFileList();
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("ServerFileManager.showFilter", this.initShowFilter);
        super.dispose();
    }

    private void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }
}

