/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.dialogs.ThemeElementEditDialog;
import org.netxms.ui.eclipse.console.resources.Theme;
import org.netxms.ui.eclipse.console.resources.ThemeElement;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class ThemeEditDialog
extends Dialog {
    public static final int COLUMN_TAG = 0;
    public static final int COLUMN_FOREGROUND = 1;
    public static final int COLUMN_BACKGROUND = 2;
    public static final int COLUMN_FONT = 3;
    private Theme theme;
    private LabeledText name;
    private TableViewer viewer;
    private ColorCache colorCache;
    private Map<String, ThemeElement> changedElements = new HashMap<String, ThemeElement>();

    public ThemeEditDialog(Shell parentShell, Theme theme) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.theme = theme;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Theme");
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("ThemeEditDialog.cx"), settings.getInt("ThemeEditDialog.cy"));
        }
        catch (NumberFormatException e) {
            newShell.setSize(670, 600);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.colorCache = new ColorCache((Control)dialogArea);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 2;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.theme.getName());
        this.name.setLayoutData(new GridData(4, 0x1000000, true, false));
        Label label = new Label(dialogArea, 0);
        label.setText("Theme elements");
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(dialogArea, 67584);
        this.setupViewer();
        this.viewer.setInput(this.theme.getTags());
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.getTable().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 1 || event.index == 2) {
                    ThemeEditDialog.this.drawColorCell(event, event.index);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ThemeEditDialog.this.editElement();
            }
        });
        return dialogArea;
    }

    private void setupViewer() {
        TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText("Tag");
        column.setWidth(400);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText("FG");
        column.setWidth(50);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText("BG");
        column.setWidth(50);
        column = new TableColumn(this.viewer.getTable(), 16384);
        column.setText("Font");
        column.setWidth(150);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((String)e1).compareToIgnoreCase((String)e2);
            }
        });
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
    }

    private void drawColorCell(Event event, int column) {
        RGB rgb;
        ThemeElement e;
        TableItem item = (TableItem)event.item;
        String tag = (String)item.getData();
        ThemeElement themeElement = e = this.changedElements.containsKey(tag) ? this.changedElements.get(tag) : this.theme.getElement(tag);
        if (e == null) {
            return;
        }
        RGB rGB = rgb = column == 1 ? e.foreground : e.background;
        if (rgb == null) {
            return;
        }
        int width = this.viewer.getTable().getColumn(column).getWidth();
        Color color = this.colorCache.create(rgb);
        event.gc.setForeground(this.colorCache.create(0, 0, 0));
        event.gc.setBackground(color);
        event.gc.setLineWidth(1);
        event.gc.fillRectangle(event.x + 3, event.y + 2, width - 7, event.height - 5);
        event.gc.drawRectangle(event.x + 3, event.y + 2, width - 7, event.height - 5);
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("ThemeEditDialog.cx", size.x);
        settings.put("ThemeEditDialog.cy", size.y);
    }

    private void editElement() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        String tag = (String)selection.getFirstElement();
        ThemeElement element = new ThemeElement(this.changedElements.containsKey(tag) ? this.changedElements.get(tag) : this.theme.getElement(tag));
        ThemeElementEditDialog dlg = new ThemeElementEditDialog(this.getShell(), element);
        if (dlg.open() == 0) {
            this.changedElements.put(tag, element);
            this.viewer.update((Object)tag, null);
        }
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.saveSettings();
        this.theme.setName(this.name.getText().trim());
        for (Map.Entry<String, ThemeElement> e : this.changedElements.entrySet()) {
            this.theme.setElement(e.getKey(), e.getValue());
        }
        super.okPressed();
    }

    private class ColorListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ColorListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return (String)element;
                }
                case 3: {
                    ThemeElement te;
                    ThemeElement themeElement = te = ThemeEditDialog.this.changedElements.containsKey(element) ? ThemeEditDialog.this.changedElements.get(element) : ThemeEditDialog.this.theme.getElement((String)element);
                    if (te.fontName == null || te.fontName.isEmpty()) {
                        return "";
                    }
                    return String.valueOf(te.fontName) + " " + Integer.toString(te.fontHeight) + "pt";
                }
            }
            return "";
        }
    }
}

