/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.propertypages.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DciListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session;
    private Map<Long, String> dciNameCache = new HashMap<Long, String>();
    private List<ChartDciConfig> elementList;

    public DciListLabelProvider(List<ChartDciConfig> elementList) {
        this.elementList = elementList;
        this.session = ConsoleSharedData.getSession();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ChartDciConfig dci = (ChartDciConfig)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(this.elementList.indexOf(dci) + 1);
            }
            case 1: {
                AbstractObject object = this.session.findObjectById(dci.nodeId);
                return object != null ? object.getObjectName() : "[" + Long.toString(dci.nodeId) + "]";
            }
            case 2: {
                String string;
                String name = this.dciNameCache.get(dci.dciId);
                if (name != null) {
                    string = name;
                } else {
                    Messages.get();
                    string = Messages.DciListLabelProvider_Unresolved;
                }
                return string;
            }
            case 3: {
                return dci.name;
            }
            case 4: {
                String string;
                if (dci.color.equalsIgnoreCase("UNSET")) {
                    Messages.get();
                    string = Messages.DciListLabelProvider_Auto;
                } else {
                    string = dci.color;
                }
                return string;
            }
        }
        return null;
    }

    public void resolveDciNames(final Collection<ChartDciConfig> dciList) {
        Messages.get();
        new ConsoleJob(Messages.DciListLabelProvider_ResolveJobName, null, "org.netxms.ui.eclipse.perfview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Map names = DciListLabelProvider.this.session.dciIdsToNames(dciList);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).DciListLabelProvider.this.dciNameCache = names;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DciListLabelProvider_ResolveJobError;
            }
        }.runInForeground();
    }

    public void addCacheEntry(long nodeId, long dciId, String name) {
        this.dciNameCache.put(dciId, name);
    }
}

