/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.interfaces.AutoBindObject;
import org.netxms.client.objects.interfaces.PollingTarget;

public class Dashboard
extends GenericObject
implements AutoBindObject,
PollingTarget {
    public static final int SHOW_AS_OBJECT_VIEW = 65536;
    private int numColumns;
    private int displayPriority;
    private List<DashboardElement> elements;
    private int autoBindFlags;
    private String autoBindFilter;

    public Dashboard(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.numColumns = msg.getFieldAsInt32(166L);
        this.displayPriority = msg.getFieldAsInt32(795L);
        this.autoBindFilter = msg.getFieldAsString(321L);
        this.autoBindFlags = msg.getFieldAsInt32(625L);
        int count = msg.getFieldAsInt32(361L);
        this.elements = new ArrayList<DashboardElement>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            this.elements.add(new DashboardElement(msg, varId));
            varId += 10L;
            ++i;
        }
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getDisplayPriority() {
        return this.displayPriority;
    }

    public List<DashboardElement> getElements() {
        return this.elements;
    }

    @Override
    public String getObjectClassName() {
        return "Dashboard";
    }

    @Override
    public boolean isAutoBindEnabled() {
        return (this.autoBindFlags & 1) > 0;
    }

    @Override
    public boolean isAutoUnbindEnabled() {
        return (this.autoBindFlags & 2) > 0;
    }

    @Override
    public String getAutoBindFilter() {
        return this.autoBindFilter;
    }

    @Override
    public int getAutoBindFlags() {
        return this.autoBindFlags;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getIfXTablePolicy() {
        return 0;
    }

    @Override
    public AgentCacheMode getAgentCacheMode() {
        return null;
    }

    @Override
    public long getPollerNodeId() {
        return 0L;
    }

    @Override
    public boolean canHaveAgent() {
        return false;
    }

    @Override
    public boolean canHaveInterfaces() {
        return false;
    }

    @Override
    public boolean canHavePollerNode() {
        return false;
    }

    @Override
    public boolean canUseEtherNetIP() {
        return false;
    }
}

