/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.propertypages;

import java.util.UUID;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.base.NXCommon;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.ui.eclipse.datacollection.widgets.DciSelector;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImageSelector;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class GeneralDCIImagePropertyPage
extends PropertyPage {
    private DciSelector dci;
    private LabeledText column;
    private LabeledText instance;
    private NetworkMapDCIImage container;
    private DCIImageConfiguration config;
    private ImageSelector image;
    private UUID selectedImage;

    protected Control createContents(Composite parent) {
        this.container = (NetworkMapDCIImage)this.getElement().getAdapter(NetworkMapDCIImage.class);
        this.config = this.container.getImageOptions();
        SingleDciConfig dciConf = this.config.getDci();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.dci = new DciSelector(dialogArea, 0);
        Messages.get();
        this.dci.setLabel(Messages.GeneralDCIImagePropertyPage_DataSource);
        if (dciConf != null) {
            this.dci.setDciId(dciConf.getNodeId(), dciConf.getDciId());
            this.dci.setDciObjectType(dciConf.getType());
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.dci.setLayoutData((Object)gd);
        this.column = new LabeledText(dialogArea, 0);
        Messages.get();
        this.column.setLabel(Messages.GeneralDCIImagePropertyPage_Column);
        if (dciConf != null) {
            this.column.setText(dciConf.getColumn());
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.column.setLayoutData((Object)gd);
        this.instance = new LabeledText(dialogArea, 0);
        Messages.get();
        this.instance.setLabel(Messages.GeneralDCIImagePropertyPage_Instance);
        if (dciConf != null) {
            this.instance.setText(dciConf.getInstance());
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.instance.setLayoutData((Object)gd);
        this.image = new ImageSelector(dialogArea, 0);
        Messages.get();
        this.image.setLabel(Messages.GeneralDCIImagePropertyPage_DefaultImage);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.image.setLayoutData((Object)gd);
        this.selectedImage = this.config.getDefaultImage();
        this.image.setImageGuid(this.selectedImage, true);
        return dialogArea;
    }

    private boolean applyChanges(boolean isApply) {
        if (this.dci.getDciId() == 0L) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.GeneralDCIImagePropertyPage_Error, (String)Messages.GeneralDCIImagePropertyPage_DciNotSelected);
            return false;
        }
        this.selectedImage = this.image.getImageGuid();
        if (this.selectedImage == null || this.selectedImage.equals(NXCommon.EMPTY_GUID)) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.GeneralDCIImagePropertyPage_Error, (String)Messages.GeneralDCIImagePropertyPage_DefImageNotSelected);
            return false;
        }
        SingleDciConfig dciConf = this.config.getDci();
        if (dciConf == null) {
            dciConf = new SingleDciConfig();
        }
        dciConf.setDciId(this.dci.getDciId());
        dciConf.setNodeId(this.dci.getNodeId());
        dciConf.setName(this.dci.getDciToolTipInfo());
        dciConf.setType(this.dci.getDciObjectType());
        dciConf.setColumn(this.column.getText());
        dciConf.setInstance(this.instance.getText());
        this.config.setDci(dciConf);
        this.config.setDefaultImage(this.selectedImage);
        this.container.setImageOptions(this.config);
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

