/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.charts.widgets.GenericComparisonChart;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class PieChart
extends GenericComparisonChart {
    private static final int MARGIN_WIDTH = 5;
    private static final int MARGIN_HEIGHT = 5;

    public PieChart(Chart parent) {
        super(parent);
    }

    @Override
    protected void createFonts() {
    }

    @Override
    protected void disposeFonts() {
    }

    @Override
    protected void render(GC gc) {
        Point size = this.getSize();
        List<GraphItem> items = this.chart.getItems();
        if (items.isEmpty() || size.x < 10 || size.y < 10) {
            return;
        }
        List<DataSeries> series = this.chart.getDataSeries();
        if (series.isEmpty()) {
            return;
        }
        double total = 0.0;
        double[] values = new double[series.size()];
        int i = 0;
        while (i < series.size()) {
            values[i] = series.get(i).getCurrentValue();
            total += values[i];
            ++i;
        }
        if (total == 0.0) {
            return;
        }
        double[] angularSize = new double[series.size()];
        int i2 = 0;
        while (i2 < values.length) {
            angularSize[i2] = values[i2] / total * 360.0;
            ++i2;
        }
        if (this.chart.getConfiguration().isTranslucent()) {
            gc.setAlpha(127);
        }
        int boxSize = Math.min(size.x - 10, size.y - 10);
        int x = (size.x - boxSize) / 2;
        int y = (size.y - boxSize) / 2;
        int startAngle = 0;
        int i3 = 0;
        while (i3 < values.length) {
            int color = items.get(i3).getColor();
            gc.setBackground(this.chart.getColorCache().create(color == -1 ? this.chart.getPaletteEntry(i3).getRGBObject() : ColorConverter.rgbFromInt((int)color)));
            int sectorSize = i3 == values.length - 1 ? 360 - startAngle : (int)Math.round(angularSize[i3]);
            gc.fillArc(x, y, boxSize, boxSize, startAngle, sectorSize);
            startAngle += sectorSize;
            ++i3;
        }
    }
}

