/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolsCache;
import org.netxms.ui.eclipse.objecttools.dialogs.ObjectToolSelectionDialog;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class ObjectToolSelector
extends AbstractSelector {
    private long toolId = 0L;

    public ObjectToolSelector(Composite parent, int style, int options) {
        super(parent, style, options);
    }

    protected void selectionButtonHandler() {
        ObjectToolSelectionDialog dlg = new ObjectToolSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            this.toolId = dlg.getTool().getId();
            this.updateToolName();
        }
    }

    protected void clearButtonHandler() {
        this.toolId = 0L;
        this.updateToolName();
    }

    public long getToolId() {
        return this.toolId;
    }

    public void setToolId(long toolId) {
        this.toolId = toolId;
        this.updateToolName();
    }

    private void updateToolName() {
        if (this.toolId == 0L) {
            this.setText("");
            return;
        }
        ObjectTool t = ObjectToolsCache.getInstance().findTool(this.toolId);
        if (t != null) {
            this.setText(t.getName());
        } else {
            this.setText("[" + this.toolId + "]");
        }
    }
}

