/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RackDisplayMode {
    FULL(0),
    FRONT(1),
    BACK(2);

    private static final Logger logger;
    private static final Map<Integer, RackDisplayMode> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(RackDisplayMode.class);
        lookupTable = new HashMap<Integer, RackDisplayMode>();
        RackDisplayMode[] rackDisplayModeArray = RackDisplayMode.values();
        int n = rackDisplayModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RackDisplayMode element = rackDisplayModeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private RackDisplayMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RackDisplayMode getByValue(int value) {
        RackDisplayMode element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return FULL;
        }
        return element;
    }
}

