/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.dialogs;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DateTimeSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class SendUserAgentNotificationDialog
extends Dialog {
    private LabeledText textMessage;
    private Button radioInstant;
    private Button radioDelayed;
    private Button radioStartup;
    private DateTimeSelector startDateSelector;
    private DateTimeSelector endDateSelector;
    private String message;
    private Date startTime;
    private Date endTime;
    private boolean startupNotification;

    public SendUserAgentNotificationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Send user support application notification");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.textMessage = new LabeledText(dialogArea, 0, 2050);
        this.textMessage.setLabel("Message text");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 200;
        gd.widthHint = 600;
        gd.horizontalSpan = 2;
        this.textMessage.setLayoutData((Object)gd);
        this.textMessage.setFocus();
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enable = SendUserAgentNotificationDialog.this.radioDelayed.getSelection() || SendUserAgentNotificationDialog.this.radioStartup.getSelection();
                SendUserAgentNotificationDialog.this.startDateSelector.setEnabled(enable);
                SendUserAgentNotificationDialog.this.endDateSelector.setEnabled(enable);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioInstant = new Button(dialogArea, 16);
        this.radioInstant.setText("Instant");
        this.radioInstant.setSelection(true);
        this.radioInstant.addSelectionListener(listener);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.radioInstant.setLayoutData((Object)gd);
        this.radioDelayed = new Button(dialogArea, 16);
        this.radioDelayed.setText("Delayed");
        this.radioDelayed.setSelection(false);
        this.radioDelayed.addSelectionListener(listener);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.radioDelayed.setLayoutData((Object)gd);
        this.radioStartup = new Button(dialogArea, 16);
        this.radioStartup.setText("Startup");
        this.radioStartup.setSelection(false);
        this.radioStartup.addSelectionListener(listener);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.radioStartup.setLayoutData((Object)gd);
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new DateTimeSelector(parent, style);
            }
        };
        this.startDateSelector = (DateTimeSelector)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)0, (WidgetFactory)factory, (String)"Valid from", (Object)"WidgetHelper::default_layout_data");
        this.startDateSelector.setValue(new Date());
        this.startDateSelector.setEnabled(false);
        this.endDateSelector = (DateTimeSelector)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)0, (WidgetFactory)factory, (String)"Valid until", (Object)"WidgetHelper::default_layout_data");
        this.endDateSelector.setValue(new Date(System.currentTimeMillis() + 86400000L));
        this.endDateSelector.setEnabled(false);
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get default user support application notification retention time", null, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final int defaultTime = session.getPublicServerVariableAsInt("UserAgent.DefaultMessageRetentionTime");
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (defaultTime > 0) {
                            (this).SendUserAgentNotificationDialog.this.endDateSelector.setValue(new Date(System.currentTimeMillis() + (long)defaultTime * 60000L));
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get default user support application notification retention time";
            }
        }.start();
        return dialogArea;
    }

    protected void okPressed() {
        this.message = this.textMessage.getText();
        if (this.radioDelayed.getSelection() || this.radioStartup.getSelection()) {
            this.startTime = this.startDateSelector.getValue();
            this.endTime = this.endDateSelector.getValue();
            this.startupNotification = this.radioStartup.getSelection();
        } else {
            this.startTime = new Date(0L);
            this.endTime = new Date(0L);
            this.startupNotification = false;
        }
        super.okPressed();
    }

    public String getMessage() {
        return this.message;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isStartupNotification() {
        return this.startupNotification;
    }
}

