/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.netxms.base.InetAddressEx;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.tools.TextFieldValidator;

public class IPNetMaskValidator
implements TextFieldValidator {
    private static final String IP_ADDRESS_PATTERN = "^([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}|[A-Fa-f0-9:]+)$";
    private boolean allowEmpty;
    private int maxBits;

    public IPNetMaskValidator(boolean allowEmpty, String ipAddress) {
        this.allowEmpty = allowEmpty;
        if (ipAddress.isEmpty()) {
            this.maxBits = 32;
        } else {
            try {
                this.maxBits = InetAddress.getByName(ipAddress) instanceof Inet4Address ? 32 : 128;
            }
            catch (UnknownHostException e) {
                this.maxBits = 32;
            }
        }
    }

    @Override
    public boolean validate(String text) {
        if (this.allowEmpty && text.trim().isEmpty()) {
            return true;
        }
        if (!text.matches(IP_ADDRESS_PATTERN)) {
            return false;
        }
        if (text.length() <= 2) {
            try {
                int bits = Integer.parseInt(text);
                return bits >= 0 && bits < this.maxBits;
            }
            catch (NumberFormatException bits) {
                // empty catch block
            }
        }
        try {
            InetAddress mask = InetAddress.getByName(text);
            int bits = InetAddressEx.bitsInMask((InetAddress)mask);
            return bits >= 0 && bits < this.maxBits;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    @Override
    public String getErrorMessage(String text, String label) {
        Messages.get();
        return String.format(Messages.IPNetMaskValidator_ErrorMessage, label);
    }
}

