/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.api;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ChartType {
    LINE(0),
    PIE(1),
    BAR(2),
    DIAL(3),
    GAUGE(4),
    TEXT(5);

    private static final Logger logger;
    private static final Map<Integer, ChartType> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(ChartType.class);
        lookupTable = new HashMap<Integer, ChartType>();
        ChartType[] chartTypeArray = ChartType.values();
        int n = chartTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartType element = chartTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private ChartType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ChartType getByValue(int value) {
        ChartType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return LINE;
        }
        return element;
    }
}

